/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.MD5Util;
import cn.yto.utils.SafeProperties;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class CommonUtils {
    private static Logger logger = CustomLoggerFactory.SystemLogger();
    public static final String TIME_ZONE_STANDARD_ID = "Asia/Shanghai";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_WINDOWS = "yyyy-MM-dd";
    public static final String DATE_FORMAT_LINUX = "yyyyMMdd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    private static final String HEADER = "Accept";
    public static TimeZone timeZoneStandard = TimeZone.getTimeZone("Asia/Shanghai");
    private static final String IP_ADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static InetAddress inetAddress = null;

    public static String convert(Date date, String format, TimeZone timeZone) {
        if (null != date) {
            if (StringUtils.isEmpty((CharSequence)format)) {
                format = DATE_TIME_FORMAT;
                logger.debug("format \u672a\u8d4b\u503c\u6216\u975e\u6cd5");
            }
            if (null == timeZone) {
                timeZone = timeZoneStandard;
                logger.debug("timeZone \u672a\u8d4b\u503c,\u53d6\u4e2d\u56fd\u6807\u51c6\u65f6\u533a");
            }
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setTimeZone(timeZone);
            return sdf.format(date);
        }
        return null;
    }

    public static void gcObject(Object ... values) {
        for (Object value : values) {
            value = null;
        }
    }

    public static void copyFile(InputStream input, String newPath) {
        FileOutputStream fs = null;
        try {
            int bytesum = 0;
            int byteread = 1024;
            fs = new FileOutputStream(newPath);
            byte[] buffer = new byte[1024];
            while ((byteread = input.read(buffer)) != -1) {
                bytesum += byteread;
                fs.write(buffer, 0, byteread);
            }
            input.close();
            fs.flush();
            fs.close();
        }
        catch (Exception e) {
            logger.debug("\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public static int dayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal.get(7);
    }

    public static int getCurentDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal.get(7) - 1;
    }

    public static <T extends Number> T filterConfigTime(String configValue, T defaultValue) {
        if (!StringUtils.isBlank((CharSequence)configValue) && configValue.trim().matches("^\\d+$")) {
            try {
                if (defaultValue instanceof Integer) {
                    return (T)(Integer.parseInt(configValue.trim()) >= 0 ? Integer.valueOf(configValue.trim()) : defaultValue);
                }
                if (defaultValue instanceof Long) {
                    return (T)(Long.parseLong(configValue.trim()) >= 0L ? Long.valueOf(configValue.trim()) : defaultValue);
                }
                if (defaultValue instanceof Float) {
                    return (T)(Float.parseFloat(configValue.trim()) >= 0.0f ? Float.valueOf(configValue.trim()) : defaultValue);
                }
                if (defaultValue instanceof Double) {
                    return (T)(Double.parseDouble(configValue.trim()) >= 0.0 ? Double.valueOf(configValue.trim()) : defaultValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static List<String> getDeleteTables(String tableName, List<Integer> deleteDays) {
        ArrayList<String> deleteTableList = new ArrayList<String>();
        StringBuilder buff = new StringBuilder();
        for (int day : deleteDays) {
            deleteTableList.add(buff.append(tableName).append(day).toString());
            buff.delete(0, buff.length());
        }
        return deleteTableList;
    }

    public static String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_LINUX);
        return formatter.format(date);
    }

    public static File createConfigDirectory(String configDir, String finalDir) {
        if (StringUtils.isBlank((CharSequence)configDir)) {
            logger.error("\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6e\u7684\u76ee\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return null;
        }
        String targetDir = configDir;
        if (!StringUtils.isBlank((CharSequence)finalDir)) {
            targetDir = CommonUtils.optimizePathSuffix(configDir) + File.separator + finalDir;
        }
        return CommonUtils.createBaseDirectory(targetDir);
    }

    public static File createDefaultDirectory(String businessDir, String finalDir) {
        if (StringUtils.isBlank((CharSequence)businessDir)) {
            logger.error("\u4e1a\u52a1\u5904\u7406\u76ee\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return null;
        }
        String defaultDir = CommonUtils.getClassPath() + File.separator + businessDir;
        if (!StringUtils.isBlank((CharSequence)finalDir)) {
            defaultDir = defaultDir + File.separator + finalDir;
        }
        return CommonUtils.createBaseDirectory(defaultDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createBaseDirectory(String dirPath) {
        File directory = new File(dirPath);
        Class<CommonUtils> clazz = CommonUtils.class;
        synchronized (CommonUtils.class) {
            if (!directory.isDirectory()) {
                boolean ok = directory.mkdirs();
                if (!ok) {
                    logger.info("\u8def\u5f84\u521b\u5efa\u5931\u8d25\uff1a" + dirPath);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                logger.info("\u8def\u5f84\u521b\u5efa\u6210\u529f\uff1a" + dirPath);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return directory;
        }
    }

    public static String getClassPath() {
        return CommonUtils.enhancePath(Thread.currentThread().getContextClassLoader().getResource(".").getPath());
    }

    public static String enhanceTimeFormat(int timePoint) {
        return Integer.toString(timePoint).length() > 1 ? timePoint + "" : "0" + timePoint;
    }

    private static String optimizePathSuffix(String path) {
        return path.endsWith("/") || path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
    }

    public static String enhancePath(String path) {
        if (path.startsWith("/") && (path = path.replaceFirst("/", "")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replaceAll("/", "\\\\");
    }

    public static int dayOflastMouth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        int dayOflastMouth = calendar.getMaximum(5);
        return dayOflastMouth;
    }

    public static int dayOfThisMouth() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        String days = sdf.format(calendar.getTime());
        int dayOfThisMouth = Integer.valueOf(days);
        return dayOfThisMouth;
    }

    public static int getDay(int args, int dateType) {
        dateType = dateType > 0 ? dateType : 5;
        int day = 0;
        Calendar calendar = Calendar.getInstance();
        if (0 == args) {
            day = calendar.get(dateType);
        } else {
            calendar.add(dateType, -args);
            day = calendar.get(dateType);
        }
        return dateType == 7 ? (day - 1 == 0 ? 7 : day - 1) : day;
    }

    public static String encryptJsonToSignature(String jsonStr, String charset) {
        String encryptSignature = null;
        try {
            int strLen = jsonStr.getBytes(charset).length;
            String srcLen = String.format("%08d", strLen);
            String decryptSignature = srcLen + jsonStr;
            logger.debug("decryptSignature:" + decryptSignature);
            encryptSignature = MD5Util.encode(decryptSignature, charset);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u52a0\u5bc6\u7b7e\u540d\u65f6\u51fa\u9519(\u65e0\u6b64\u7b97\u6cd5)");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u52a0\u5bc6\u7b7e\u540d\u65f6\u51fa\u9519(\u4e0d\u652f\u6301\u7684\u7f16\u7801\u683c\u5f0f)");
        }
        return encryptSignature;
    }

    public static boolean isToday(Date date) {
        if (date == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_WINDOWS);
        return sdf.format(new Date()).equals(sdf.format(date));
    }

    public static <T> T convertJsonToBean(String jsonStr, TypeToken<T> t) {
        Object resultObject = null;
        try {
            resultObject = new GsonBuilder().serializeNulls().create().fromJson(jsonStr, t.getType());
        }
        catch (JsonSyntaxException e) {
            logger.error("\u8bf7\u6c42\u6570\u636e\u8f6c\u5bf9\u8c61\u5931\u8d25...", e.getCause());
        }
        return (T)resultObject;
    }

    public static boolean isDateTimeOut(String dateStr, int timeOutMonth) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_LINUX);
        try {
            formatter.parse(dateStr);
            String dirDateStr = dateStr.substring(0, dateStr.length() - 2);
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, calendar.get(2) - timeOutMonth + 1);
            String currentDateStr = formatter.format(calendar.getTime());
            currentDateStr = currentDateStr.substring(0, currentDateStr.length() - 2);
            return currentDateStr.compareTo(dirDateStr) >= 0;
        }
        catch (ParseException e) {
            logger.error("\u65e0\u6cd5\u89e3\u6790\u5b57\u7b26\u4e32\u4e3a\u65e5\u671f\u683c\u5f0f");
            return false;
        }
    }

    public static <T> Map<String, Object> convertBeanToMap(T t) {
        HashMap<String, Object> mm = new HashMap<String, Object>();
        Class<?> clz = t.getClass();
        List names = Arrays.stream(clz.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        names.stream().forEach(name -> {
            try {
                Field field = clz.getDeclaredField((String)name);
                field.setAccessible(true);
                mm.put((String)name, field.get(t));
            }
            catch (Exception e) {
                logger.error(clz.getName() + "\u7c7b\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027 -> " + name);
            }
        });
        return mm;
    }

    public static List<Integer> convertToIntegerList(List<String> idList) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try {
            for (String id : idList) {
                int primary = Integer.parseInt(id);
                ids.add(primary);
            }
        }
        catch (NumberFormatException e) {
            logger.error("\u524d\u7aef\u53c2\u6570\u4f20\u9012\u6709\u8bef\uff0c\u6279\u91cf\u5220\u9664\u65f6\uff0c\u4f20\u6765\u7684ID\u4e0d\u80fd\u89e3\u6790\u4e3a\u6570\u5b57");
            return null;
        }
        return ids;
    }

    public static double convertStringToDouble(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return 0.0;
        }
        double result = 0.0;
        try {
            result = Double.parseDouble(num);
        }
        catch (Exception e) {
            logger.error("\u5b57\u7b26\u4e32\u4e0d\u80fd\u8f6c\u6362\u6210\u6d6e\u70b9\u6570\uff0c\u8bf7\u68c0\u67e5", e.getCause());
        }
        return result < 0.0 ? 0.0 : result;
    }

    public static <T> T getInstance(Supplier<T> supplier) {
        return supplier.get();
    }

    public static synchronized InetAddress getLocalHostLANAddress() {
        if (inetAddress != null) {
            return inetAddress;
        }
        try {
            ArrayList<InetAddress> candidateIpList = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.getHostAddress().contains(":") || inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        inetAddress = inetAddr;
                        return inetAddr;
                    }
                    if (!inetAddr.getHostAddress().matches(IP_ADDRESS_PATTERN)) continue;
                    candidateIpList.add(inetAddr);
                }
            }
            if (!CollectionUtils.isEmpty(candidateIpList)) {
                inetAddress = (InetAddress)candidateIpList.get(0);
                return inetAddress;
            }
            inetAddress = InetAddress.getLocalHost();
            return inetAddress;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u672c\u673aIP\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(SafeProperties properties, String path, String comments) {
        if (properties == null) {
            return;
        }
        if (path == null || path.isEmpty()) {
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(path));
            properties.store(outputStream, comments);
        }
        catch (FileNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u914d\u7f6e\u6587\u4ef6\uff1a" + path);
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a" + path);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u65f6\uff0c\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + path);
            }
        }
    }

    public static RestTemplate getRestTemplate(int timeout) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(timeout);
        requestFactory.setReadTimeout(timeout);
        RestTemplate restTemp = new RestTemplate();
        restTemp.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemp.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemp;
    }

    public static <T> ResponseEntity<T> sendPostRequest(RestTemplate restTemplate, String url, Object msgBody, Class<T> responseType) {
        ResponseEntity response = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(HEADER, "application/json;charset=UTF-8");
        HttpEntity httpEntity = new HttpEntity(msgBody, (MultiValueMap)headers);
        try {
            response = restTemplate.postForEntity(url, (Object)httpEntity, responseType, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42{}\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
        }
        return response;
    }
}

