/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.CommonUtils;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;

public class DateTimeSynchronizeUtil {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    public static final long DATETIME_DIFF = 30000L;
    public static final int HINT_VALUE = 6;
    public static final int MAX_VALUE = 100;
    final Object lock = new Object();

    public static DateTimeSynchronizeUtil getInstance() {
        return DateTimeSynchronizeServiceHolder.dateTimeSynchronizeService;
    }

    private boolean canSynchronizeByRandom() {
        int random = (int)(Math.random() * 100.0) % 100;
        return 6 == random;
    }

    public boolean canSynchronizeByDiff(Date serverTime) {
        Date localTime = new Date();
        TimeZone tzClient = TimeZone.getDefault();
        if (!tzClient.getID().equals("Asia/Shanghai")) {
            logger.warn("\u672c\u673a\u975e\u6807\u51c6GMT+8:00\u65f6\u533a,\u4e0d\u66f4\u65b0\u672c\u5730\u65f6\u95f4; TimeZoneStandard=Asia/Shanghai, TimeZoneClient=" + tzClient.getID());
            return false;
        }
        return Math.abs(localTime.getTime() - serverTime.getTime()) > 30000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dateTimeRandomSynchronize(Date serverTime) {
        if (this.canSynchronizeByDiff(serverTime)) {
            Object object = this.lock;
            synchronized (object) {
                this.synchronizeSystemDateTime(serverTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dateTimeInitSynchronize(Date serverTime) {
        if (this.canSynchronizeByDiff(serverTime)) {
            Object object = this.lock;
            synchronized (object) {
                logger.info("\u5ba2\u6237\u673a\u4e0e\u670d\u52a1\u5668\u65f6\u949f\u4e0d\u4e00\u81f4,serverTime:" + CommonUtils.convert(serverTime, "yyyy-MM-dd HH:mm:ss", null) + ",localTime:" + CommonUtils.convert(new Date(), "yyyy-MM-dd HH:mm:ss", null));
                this.synchronizeSystemDateTime(serverTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dateTimeSynchronize(Date serverTime) {
        if (this.canSynchronizeByDiff(serverTime)) {
            Object object = this.lock;
            synchronized (object) {
                logger.info("\u5ba2\u6237\u673a\u4e0e\u670d\u52a1\u5668\u65f6\u949f\u4e0d\u4e00\u81f4,serverTime:" + CommonUtils.convert(serverTime, "yyyy-MM-dd HH:mm:ss", null) + ",localTime:" + CommonUtils.convert(new Date(), "yyyy-MM-dd HH:mm:ss", null));
                this.synchronizeSystemDateTime(serverTime);
            }
        }
    }

    private void synchronizeSystemDateTime(Date serverTime) {
        String osName = System.getProperty("os.name");
        String cmd = "";
        try {
            if (osName.matches("^(?i)Windows.*$")) {
                String strServerDate = CommonUtils.convert(serverTime, "yyyy-MM-dd", null);
                String strServerTime = CommonUtils.convert(serverTime, "HH:mm:ss", null);
                cmd = " cmd /c date " + strServerDate;
                Runtime.getRuntime().exec(cmd);
                cmd = " cmd /c time " + strServerTime;
                Runtime.getRuntime().exec(cmd);
                logger.info("\u8bbe\u7f6e\u672c\u673a\u65f6\u95f4:" + strServerDate + "," + strServerTime);
            }
        }
        catch (Throwable e) {
            logger.error("DateTimeSynchronize", e);
        }
    }

    public static void main(String[] args) throws IOException {
        Runtime.getRuntime().exec("cmd /c date 2022-09-19");
    }

    static class DateTimeSynchronizeServiceHolder {
        static DateTimeSynchronizeUtil dateTimeSynchronizeService = new DateTimeSynchronizeUtil();

        DateTimeSynchronizeServiceHolder() {
        }
    }
}

