/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    static final String PATTERN_HH = "HH";
    static final String PATTERN_HHmm = "HH:mm";
    static final String PATTERN_MMDD = "MMdd";
    static final String PATTERN_YYMM = "yyyyMM";
    static final String PATTERN_YMMDD = "yyMMdd";
    static final String PATTERN_YYMMDD = "yyyyMMdd";
    static final String PATTERN_MDHMS = "MM\u6708dd\u65e5 HH:mm:ss";
    public static final String PATTERN_YMDHMSSS = "yyyyMMddHHmmssSSS";
    static final String PATTERN_YYM_MM_DD = "yyyy-MM-dd";
    static final String PATTERN_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_YMDHMSS = "yyyy-MM-dd HH:mm:ss.SSS";
    static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS").withZone(ZoneId.systemDefault());
    public static final Integer HOUR_15 = 15;

    public static String formatTodayYMD() {
        return DateUtil.formatYMD(new Date());
    }

    public static String formatTodayYM() {
        return DateUtil.formatYM(new Date());
    }

    public static String todayYMDHMSSS() {
        return DateUtil.formatYMDHMSSS(new Date());
    }

    public static String formatH(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_HH);
        return sdf.format(curDate);
    }

    public static String formatYM(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YYMM);
        return sdf.format(curDate);
    }

    public static String formatYYMD(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMMDD);
        return sdf.format(curDate);
    }

    public static String formatYMD(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YYMMDD);
        return sdf.format(curDate);
    }

    public static String formatYMDHMSSS(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMSSS);
        return sdf.format(curDate);
    }

    public static String formatYMDHMSS(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMSS);
        return sdf.format(curDate);
    }

    public static String formatYMDHMS(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMS);
        return sdf.format(curDate);
    }

    public static Date praseDate(String curDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMS);
        return sdf.parse(curDate);
    }

    public static Date parseDate(String curDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YYM_MM_DD);
        return sdf.parse(curDate);
    }

    public static Date formatHHmm(String curDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_HHmm);
        return sdf.parse(curDate);
    }

    public static String formatMDHMS(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_MDHMS);
        return sdf.format(curDate);
    }

    public static Date getDateFromMills(Long secodes) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(secodes);
        return cal.getTime();
    }

    public static String addHour(String curDate, int hour) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.praseDate(curDate));
        cal.add(11, hour);
        return DateUtil.formatYMDHMS(cal.getTime());
    }

    public static Date addMinute(Date curDate, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.add(12, minute);
        return cal.getTime();
    }

    public static Date addSecond(Date curDate, int second) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.add(13, second);
        return cal.getTime();
    }

    public static Date getCurrentMinute() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(13, 0);
        return cal.getTime();
    }

    public static boolean checkTonightZeroTime(Date currentDate) {
        Calendar tonight = Calendar.getInstance();
        tonight.setTime(currentDate);
        tonight.set(13, 0);
        tonight.set(12, 0);
        tonight.set(11, 0);
        return tonight.getTime().getTime() == currentDate.getTime();
    }

    public static String formatToHHmm(String strDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_HHmm);
        Date date = DateUtil.praseDate(strDate);
        return sdf.format(date);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date, PATTERN_YMDHMS);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.formatDate(date, PATTERN_YMDHMSS);
    }

    public static String formatDate(Date date, String format) {
        if (null == date) {
            return null;
        }
        if (null == format || "".equals(format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date formatDate(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMS);
        Date result = null;
        try {
            result = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date formatDate(String dateStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date result = null;
        try {
            result = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String formatDate(String dateStr, int time) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMSS);
        Calendar cal = Calendar.getInstance();
        String result = null;
        try {
            Date date = sdf.parse(dateStr);
            cal.setTime(date);
            cal.add(12, time);
            cal.getTime().toString();
            result = sdf.format(cal.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Long curTimeStamp() {
        return System.currentTimeMillis();
    }

    public static Long transForMillis(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Long transForMillis(String dateStr) {
        Date date = DateUtil.formatDate(dateStr);
        return date == null ? null : DateUtil.transForMillis(date);
    }

    public static Long transForMillis(String dateStr, String format) {
        Date date = DateUtil.formatDate(dateStr, format);
        return date == null ? null : DateUtil.transForMillis(date);
    }

    public static String convertTimeToString(Long time) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(PATTERN_YMDHMSS);
        String timeStr = dateTimeFormatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
        return timeStr;
    }

    public static boolean timeDifference(Date startDate, Date endDate, int hourDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMSS);
        if (endDate.getTime() > startDate.getTime()) {
            long hourTime = (endDate.getTime() - startDate.getTime()) / 1000L / 60L / 60L;
            return hourTime > (long)hourDate;
        }
        return false;
    }

    public static long secondDifference(long startTime, long endTime) {
        long timeDifference = endTime - startTime;
        long second = timeDifference / 1000L;
        return second;
    }

    public static String formatDate() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter format = DateTimeFormatter.ofPattern(PATTERN_MMDD);
        return now.format(format);
    }

    public static String dayOfTime(Date date, int day) {
        Calendar cal = null;
        String result = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMSS);
            cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, day);
            result = sdf.format(cal.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getFileModifyTime(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        BasicFileAttributes bAttributes = null;
        try {
            bAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            Instant instant = bAttributes.lastModifiedTime().toInstant();
            String format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS").withZone(ZoneId.systemDefault()).format(instant);
            return format;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Long getDifDays(Date d1, Date d2) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YYM_MM_DD);
        try {
            d1 = sdf.parse(sdf.format(d1));
            d2 = sdf.parse(sdf.format(d2));
            Calendar cal = Calendar.getInstance();
            cal.setTime(d1);
            long time1 = cal.getTimeInMillis();
            cal.setTime(d2);
            long time2 = cal.getTimeInMillis();
            return Math.abs((time2 - time1) / 86400000L);
        }
        catch (ParseException e) {
            return 0L;
        }
    }
}

