/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.hutool.core.util.StrUtil;
import cn.yto.utils.GoogleJsonUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ExpUtils {
    public static final String PATTERN_DATETIME_MILL = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_YMDHMSSS = "yyyyMMddHHmmssSS";
    public static final String PATTERN_HHmm = "HH:mm";
    public static final String NEED_CHECK_LOG = "(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)";

    public static boolean isNotBlank(String str) {
        return !ExpUtils.isBlank(str);
    }

    public static boolean isBlank(String str) {
        return StringUtils.isBlank((CharSequence)str) || "null".equals(str);
    }

    public static boolean isLetterDigit(String str) {
        if (ExpUtils.isBlank(str)) {
            return false;
        }
        String regex = "^[a-z0-9A-Z]+$";
        return str.matches(regex);
    }

    public static Date parseDateTimeMill(String dateTimeStr) {
        if (ExpUtils.isBlank(dateTimeStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATETIME_MILL);
        Date result = null;
        try {
            result = sdf.parse(dateTimeStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static Date parseDateTimeMillWithDefault(String dateTimeStr) {
        Date now = new Date();
        if (ExpUtils.isBlank(dateTimeStr)) {
            return now;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATETIME_MILL);
        Date result = now;
        try {
            result = sdf.parse(dateTimeStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static String formatDateTimeMill(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATETIME_MILL);
        return sdf.format(date);
    }

    public static Date parseDateTime(String dateTimeStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATETIME);
        Date result = null;
        try {
            result = sdf.parse(dateTimeStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static String formatDateTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATETIME);
        return sdf.format(date);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE);
        return sdf.format(date);
    }

    public static String formatYMDHMSSS(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_YMDHMSSS);
        return sdf.format(date);
    }

    public static Date parseHHmm(String dateTimeStr) {
        if (ExpUtils.isBlank(dateTimeStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_HHmm);
        Date result = null;
        try {
            result = sdf.parse(dateTimeStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static String formatHHmm(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_HHmm);
        return sdf.format(date);
    }

    public static Double toDouble(String num) {
        try {
            BigDecimal bd = new BigDecimal(num);
            Double d = bd.setScale(2, 4).doubleValue();
            return d;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String toDoubleStr(String num) {
        if (ExpUtils.isBlank(num)) {
            return "0.00";
        }
        Double d = ExpUtils.toDouble(num);
        if (d == null) {
            return "0.00";
        }
        return d.toString();
    }

    public static String setToString(Set<String> container) {
        String result = "";
        for (String s : container) {
            if (ExpUtils.isBlank(result)) {
                result = result + s;
                continue;
            }
            result = result + "," + s;
        }
        return result;
    }

    public static String shortenResp(Object resp) {
        if (resp == null) {
            return null;
        }
        String responseJson = GoogleJsonUtil.toJson(resp);
        if (StringUtils.isNotBlank((CharSequence)responseJson) && responseJson.length() > 1000) {
            responseJson = responseJson.substring(0, 1000) + "...";
        }
        return responseJson;
    }

    public static Date addYear(Date curDate, int year) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.add(1, year);
        return cal.getTime();
    }

    public static Date addHour(Date curDate, int hour) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.add(11, hour);
        return cal.getTime();
    }

    public static Date addMinute(Date curDate, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.add(12, minute);
        return cal.getTime();
    }

    public static String latticeNoFill(String latticeNo) {
        if (ExpUtils.isBlank(latticeNo)) {
            return latticeNo;
        }
        String latticeNoFill = StrUtil.fillBefore((String)latticeNo, (char)'0', (int)3);
        return latticeNoFill;
    }

    private static String latticeNoWithCommaFill(String latticeNos) {
        StringBuilder builder = new StringBuilder();
        if (ExpUtils.isBlank(latticeNos)) {
            return latticeNos;
        }
        String[] lattice = latticeNos.split(",");
        for (int i = 0; i < lattice.length; ++i) {
            String latticeNoFill = ExpUtils.latticeNoFill(lattice[i]);
            builder.append(latticeNoFill);
            if (i == lattice.length - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static String latticeNoWithSemiFill(String latticeNos) {
        StringBuilder builder = new StringBuilder();
        if (ExpUtils.isBlank(latticeNos)) {
            return latticeNos;
        }
        String[] lattice = latticeNos.split(";");
        for (int i = 0; i < lattice.length; ++i) {
            String latticeNoFill = ExpUtils.latticeNoWithCommaFill(lattice[i]);
            builder.append(latticeNoFill);
            if (i == lattice.length - 1) continue;
            builder.append(";");
        }
        return builder.toString();
    }

    public static boolean isDoubleNull(Double d) {
        if (d == null) {
            return true;
        }
        return !(d > 1.0E-4) && !(d < -1.0E-4);
    }

    public static String getLastSegment(String threeCode) {
        if (ExpUtils.isBlank(threeCode)) {
            return null;
        }
        String[] split = threeCode.split("-");
        String result = split[split.length - 1];
        return result;
    }

    public static int moldLastIndex(String val, int number) {
        int index = 0;
        if (StringUtils.isNotBlank((CharSequence)val)) {
            try {
                index = Integer.parseInt(StringUtils.right((String)val, (int)1));
            }
            catch (Exception e) {
                index = 0;
            }
        }
        return ExpUtils.mold(index, number);
    }

    public static int mold(int val, int number) {
        return val % number;
    }

    public static boolean isAbnormalThreeCode(String threeCode) {
        if (ExpUtils.isBlank(threeCode)) {
            return false;
        }
        return threeCode.startsWith("-");
    }
}

