/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class FileUtil {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    public static final String DIR_APP_TEMP = "temp";
    public static final String DIR_COMMON = "codeVisionFiles";
    public static final String DIR_DEFAULT_IMAGE = "image";
    public static final String DIR_CALIBRATE_SCALE_IMAGE = "calibrateScaleImages";
    public static final String DIR_OPT_IMAGE = "opt";
    public static final String DIR_UPGRADE_PKG = "upgradePkg";
    public static final String DIR_UPGRADE_PKG_MONITOR = "monitorGateway";
    public static final String DIR_UPGRADE_PKG_BUSI = "busiGateway";
    public static final String DIR_UPGRADE_PKG_CODEVISION = "codeVision";
    public static final String DIR_UPGRADE_PKG_WCS = "wcs";
    public static final String DIR_BACKUP = "backup";
    public static final String DIR_BACKUP_SQL = "sql";
    private static final String DEFAULT_DISK = "C:";
    public static final String MACHINE_ID_PATH_WINDOWS = "windows";
    public static final String MACHINE_ID_PATH_LINUX = "etc";
    public static final String MACHINE_ID_FILE_NAME = "image11223344.json";
    public static final String FILE_NAME_APP_VERSION = "app.version";

    public static String getSystemTempDir() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return FileUtils.getTempDirectoryPath();
        }
        return FileUtils.getTempDirectoryPath() + File.separator;
    }

    public static String getMachineIdFileDir(String configDisk) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return FileUtil.getWindowsDir(configDisk);
        }
        return FileUtil.getLinuxDir();
    }

    private static String getWindowsDir(String configDisk) {
        String path = null;
        path = ExpUtils.isNotBlank(configDisk) ? (FileUtil.checkListRoots(configDisk.toUpperCase()) ? configDisk.toUpperCase() + File.separator + MACHINE_ID_PATH_WINDOWS : DEFAULT_DISK + File.separator + MACHINE_ID_PATH_WINDOWS) : DEFAULT_DISK + File.separator + MACHINE_ID_PATH_WINDOWS;
        return path;
    }

    private static String getLinuxDir() {
        return File.separator + MACHINE_ID_PATH_LINUX;
    }

    private static boolean checkListRoots(String diskName) {
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].getPath().contains(diskName)) continue;
            return true;
        }
        return false;
    }

    public static String getAppTempDir() {
        return FileUtil.getAppDir() + File.separator + DIR_APP_TEMP;
    }

    public static String getAppDir() {
        try {
            return new ClassPathResource("").getFile().getAbsolutePath();
        }
        catch (IOException e) {
            return FileUtil.class.getClassLoader().getResource("").getPath();
        }
    }

    public static String getSqlBackupDir() {
        return FileUtil.getAppDir() + File.separator + DIR_BACKUP + File.separator + DIR_BACKUP_SQL;
    }

    public static String getAppParentDir() {
        return new File(FileUtil.getAppDir()).getParentFile().getAbsolutePath();
    }

    public static String getDisk() {
        if (SystemUtils.IS_OS_WINDOWS) {
            String userDir = SystemUtils.USER_DIR;
            return userDir.substring(0, userDir.indexOf(File.separator));
        }
        return File.separator;
    }

    public static String getCommonDir() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return FileUtil.getDisk() + File.separator + DIR_COMMON;
        }
        return FileUtil.getDisk() + DIR_COMMON;
    }

    public static String getUpgradePkgDir() {
        return FileUtil.getCommonDir() + File.separator + DIR_UPGRADE_PKG;
    }

    public static String getCommonImageDir() {
        return FileUtil.getCommonDir() + File.separator + DIR_DEFAULT_IMAGE;
    }

    public static String getConfigCalibrateScaleImageDir(String configPath, String day) {
        return FileUtil.optimizePathSuffix(configPath) + File.separator + DIR_CALIBRATE_SCALE_IMAGE + (StringUtils.isBlank((CharSequence)day) ? "" : File.separator + day);
    }

    public static String getDefaultCalibrateScaleImageDir(String day) {
        return FileUtil.getCommonImageDir() + File.separator + DIR_CALIBRATE_SCALE_IMAGE + (StringUtils.isBlank((CharSequence)day) ? "" : File.separator + day);
    }

    public static String getConfigOptImageDir(String configPath, String day) {
        return FileUtil.optimizePathSuffix(configPath) + File.separator + DIR_OPT_IMAGE + (StringUtils.isBlank((CharSequence)day) ? "" : File.separator + day);
    }

    public static String getDefaultOptImageDir(String day) {
        return FileUtil.getCommonImageDir() + File.separator + DIR_OPT_IMAGE + (StringUtils.isBlank((CharSequence)day) ? "" : File.separator + day);
    }

    public static String getUpgradePkgMonitorDir() {
        return FileUtil.getUpgradePkgDir() + File.separator + DIR_UPGRADE_PKG_MONITOR;
    }

    public static String getUpgradePkgBusiDir() {
        return FileUtil.getUpgradePkgDir() + File.separator + DIR_UPGRADE_PKG_BUSI;
    }

    public static String getUpgradePkgCodeVisionDir(String version) {
        return FileUtil.getUpgradePkgDir() + File.separator + DIR_UPGRADE_PKG_CODEVISION + (StringUtils.isBlank((CharSequence)version) ? "" : File.separator + version);
    }

    public static String getUpgradePkgWcsDir() {
        return FileUtil.getUpgradePkgDir() + File.separator + DIR_UPGRADE_PKG_WCS;
    }

    private static String optimizePathSuffix(String path) {
        return path.endsWith("/") || path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
    }

    public static File mkdirs(String dirPath) {
        File file = new File(dirPath);
        if (file.exists()) {
            if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            }
        } else {
            file.mkdirs();
        }
        return file;
    }

    public static File splicingAndMkdirs(String ... dirPath) {
        StringJoiner stringJoiner = new StringJoiner(File.separator);
        for (String s : dirPath) {
            stringJoiner.add(FileUtil.optimizePathSuffix(s));
        }
        return FileUtil.mkdirs(stringJoiner.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compressFiles(String zipPathDir, String zipFileName, List<File> fileList) {
        File zipFile = new File(zipPathDir);
        if (!zipFile.exists()) {
            zipFile.mkdirs();
        }
        File resFile = new File(zipPathDir + File.separator + zipFileName);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(resFile));){
            for (File file2 : fileList) {
                if (!file2.exists()) continue;
                ZipEntry zipEntry = new ZipEntry(file2.getName());
                zos.putNextEntry(zipEntry);
                byte[] buffer = new byte[2048];
                FileUtil.compressSingleFile(file2, zos, buffer);
            }
            zos.flush();
            File file = resFile;
            return file;
        }
        catch (Exception e) {
            logger.error("\u538b\u7f29\u6240\u6709\u6587\u4ef6\u6210zip\u5305\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public static void compressSingleFile(File file, ZipOutputStream zos, byte[] buffer) {
        try (FileInputStream fis = new FileInputStream(file);){
            int len;
            while ((len = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
                zos.flush();
            }
            zos.closeEntry();
        }
        catch (IOException e) {
            logger.error("\u538b\u7f29\u5355\u4e2a\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void writeText(File file, String text) {
        text = text == null ? "" : text;
        try (FileOutputStream fos = new FileOutputStream(file);){
            if (!file.exists()) {
                file.createNewFile();
            }
            fos.write(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u672c\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void writeText(String file, String text) {
        FileUtil.writeText(new File(file), text);
    }

    public static void recursiveDeleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                FileUtil.recursiveDeleteFile(f);
            }
        }
        file.delete();
    }

    public static Date getFileCreationTime(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        String absolutePath = file.getAbsolutePath();
        Path path = Paths.get(absolutePath, new String[0]);
        BasicFileAttributes attrs = null;
        try {
            attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u521b\u5efa\u65f6\u95f4\u5931\u8d25\uff1a{}", (Object)file, (Object)e);
            return null;
        }
        FileTime fileTime = attrs.creationTime();
        long l = fileTime.toMillis();
        return new Date(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSha1(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = DigestUtils.sha1Hex((InputStream)fis);
            return string;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6sha1\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMd5(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = DigestUtils.md5Hex((InputStream)fis);
            return string;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6md5\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteExpiredDir(File parentDir, Date date, long days) throws IOException {
        if (parentDir == null || date == null || !parentDir.exists() || !parentDir.isDirectory()) {
            return;
        }
        File[] dirs = parentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (dirs == null || dirs.length == 0) {
            return;
        }
        for (File dir : dirs) {
            Path path = Paths.get(dir.getAbsolutePath(), new String[0]);
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = attrs.creationTime();
            Date dirCreateDate = new Date(fileTime.toMillis());
            long difDays = DateUtil.getDifDays(dirCreateDate, date);
            if (difDays <= days) continue;
            int listSize = 0;
            String[] list = dir.list();
            if (list != null) {
                listSize = list.length;
            }
            String dirPath = dir.getPath();
            logger.info("\u5f00\u59cb\u5220\u9664\u76ee\u5f55 {} \u5176\u5185\u90e8\u6587\u4ef6\u6570\u91cf {}", (Object)dirPath, (Object)listSize);
            long l = System.currentTimeMillis();
            FileUtil.recursiveDeleteFile(dir);
            logger.info("\u5220\u9664\u76ee\u5f55\u5b8c\u6210 {} \u8017\u65f6 {} ", (Object)dirPath, (Object)(System.currentTimeMillis() - l));
        }
    }
}

