/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.utils.DateUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import javax.imageio.ImageIO;

public class ImageProcUtils {
    public static final String FONT_NAME = "\u5b8b\u4f53";
    public static final int FONT_STYLE = 0;
    public static final int FONT_SIZE = 40;
    public static final Font DEFAULT_FONT = new Font("\u5b8b\u4f53", 0, 40);
    public static float ALPHA = 0.8f;

    public static void markImageByText(String sourcePath, String outputPath, String imageName, String imageType, String ... word) throws IOException {
        File file = new File(sourcePath);
        BufferedImage image = ImageIO.read(file);
        int width = ((Image)image).getWidth(null);
        int height = ((Image)image).getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        graphics2D.setFont(new Font(FONT_NAME, 0, 40));
        graphics2D.setColor(Color.BLACK);
        graphics2D.setComposite(AlphaComposite.getInstance(10, ALPHA));
        for (int i = 0; i < word.length; ++i) {
            graphics2D.drawString(word[i], 50, 100 * (i + 1));
        }
        graphics2D.dispose();
        File sf = new File(outputPath, imageName);
        ImageIO.write((RenderedImage)bufferedImage, imageType, sf);
    }

    public static void compressImage(File file) throws IOException {
        BufferedImage originalImage = ImageIO.read(file);
        if (originalImage == null) {
            throw new IOException("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247: " + file.getPath());
        }
        int newWidth = originalImage.getWidth() / 2;
        int newHeight = originalImage.getHeight() / 2;
        BufferedImage compressedImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = compressedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.drawImage(originalImage, 0, 0, newWidth, newHeight, null);
        ImageIO.write((RenderedImage)compressedImage, "jpg", file);
        g2d.dispose();
        originalImage.flush();
        originalImage = null;
        compressedImage.flush();
        compressedImage = null;
    }

    public static void markImageByFile(String compress, File file, String ... word) throws IOException {
        BufferedImage original = ImageIO.read(file);
        if (original == null) {
            throw new IOException("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247: " + file.getPath());
        }
        BufferedImage compressedImage = null;
        Graphics2D graphics2D = null;
        if ("1".equals(compress)) {
            int newWidth = original.getWidth() / 2;
            int newHeight = original.getHeight() / 2;
            compressedImage = new BufferedImage(newWidth, newHeight, 1);
            graphics2D = compressedImage.createGraphics();
        } else {
            graphics2D = original.createGraphics();
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if ("1".equals(compress)) {
            graphics2D.drawImage(original, 0, 0, original.getWidth() / 2, original.getHeight() / 2, null);
        } else {
            graphics2D.drawImage(original, 0, 0, original.getWidth(), original.getHeight(), null);
        }
        graphics2D.setFont(DEFAULT_FONT);
        graphics2D.setColor(Color.WHITE);
        for (int i = 0; i < word.length; ++i) {
            graphics2D.drawString(word[i], 10, 50 * (i + 1));
        }
        String imageType = file.getName().substring(file.getName().lastIndexOf(".") + 1).toLowerCase();
        if ("1".equals(compress)) {
            ImageIO.write((RenderedImage)compressedImage, imageType, file);
        } else {
            ImageIO.write((RenderedImage)original, imageType, file);
        }
        graphics2D.dispose();
        original.flush();
        original = null;
        if (Objects.nonNull(compressedImage)) {
            compressedImage.flush();
            compressedImage = null;
        }
    }

    public static void main(String[] args) throws IOException {
        String sourcePath = "C:\\Users\\admin\\Desktop\\\u65b0\u5efa\u6587\u4ef6\u5939 (2)\\12345.jpg";
        String word = "\u8fd0\u5355\u53f7:12345678900004535";
        String dateTime = DateUtil.formatDateTime(new Date());
        long start = System.currentTimeMillis();
        File file = new File(sourcePath);
        ImageProcUtils.markImageByFile("1", file, word, dateTime);
        System.out.println("\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        System.out.println("\u8017\u65f62\uff1a" + (System.currentTimeMillis() - start));
    }
}

