/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.date.DateUnit;

public class LocalCacheUtil {
    private static final Long DEFAULT_TIMEOUT = 600000L;
    private static final Long CLEAN_TIMEOUT = 60000L;
    public static TimedCache<String, Object> timedCache = CacheUtil.newTimedCache((long)DEFAULT_TIMEOUT);

    public static void put(String key, Object value) {
        timedCache.put((Object)key, value);
    }

    public static void put(String key, Object value, Integer expire) {
        timedCache.put((Object)key, value, DateUnit.SECOND.getMillis() * (long)expire.intValue());
    }

    public static Object get(String key, boolean isUpdateLastAccess) {
        return timedCache.get((Object)key, isUpdateLastAccess);
    }

    public static Object get(String key) {
        return timedCache.get((Object)key);
    }

    public static void remove(String key) {
        timedCache.remove((Object)key);
    }

    public static void clear() {
        timedCache.clear();
    }

    static {
        timedCache.schedulePrune(CLEAN_TIMEOUT.longValue());
    }
}

