/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.log.CustomLoggerFactory;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;

public class MD5Util {
    private static final Logger logger = CustomLoggerFactory.ImageLogger();
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static final char[] hexDigitChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(MD5Util.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String encode(String origin, String charse) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String resultString = null;
        resultString = new String(origin);
        MessageDigest md = MessageDigest.getInstance("MD5");
        resultString = charse == null || "".equals(charse) ? MD5Util.byteArrayToHexString(md.digest(resultString.getBytes())) : MD5Util.byteArrayToHexString(md.digest(resultString.getBytes(charse)));
        return resultString;
    }

    public static String encodeTo32BitStr(String key) throws NoSuchAlgorithmException {
        byte[] btInput = key.getBytes();
        MessageDigest mdInst = MessageDigest.getInstance("MD5");
        mdInst.update(btInput);
        byte[] md = mdInst.digest();
        int j = md.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md[i];
            str[k++] = hexDigitChars[byte0 >>> 4 & 0xF];
            str[k++] = hexDigitChars[byte0 & 0xF];
        }
        return new String(str);
    }

    public static String EncodeMD5Base64(String str) {
        byte[] source = str.getBytes();
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        byte[] d = md5.digest(source);
        if (d == null) {
            return "";
        }
        return new String(Base64.encodeBase64((byte[])d));
    }

    public static String encryptJsonToSignature(String jsonStr, String charset) {
        String encryptSignature = null;
        try {
            int strLen = jsonStr.getBytes(charset).length;
            String srcLen = String.format("%08d", strLen);
            String decryptSignature = srcLen + jsonStr;
            encryptSignature = MD5Util.encode(decryptSignature, charset);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u52a0\u5bc6\u7b7e\u540d\u65f6\u51fa\u9519(\u65e0\u6b64\u7b97\u6cd5)");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u52a0\u5bc6\u7b7e\u540d\u65f6\u51fa\u9519(\u4e0d\u652f\u6301\u7684\u7f16\u7801\u683c\u5f0f)");
        }
        return encryptSignature;
    }
}

