/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.utils.GoogleJsonUtil;
import cn.yto.utils.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestTemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateUtil.class);
    private static final String HEADER = "Accept";
    private static RestTemplate restTemplate;

    public static RestTemplate getRestTemplate() {
        if (restTemplate == null) {
            restTemplate = SpringUtil.getBean(RestTemplate.class);
        }
        return restTemplate;
    }

    public static <T> ResponseEntity<T> get(String url, Class<T> responseType) {
        return RestTemplateUtil.getRestTemplate().getForEntity(url, responseType, new Object[0]);
    }

    public <T> ResponseEntity<T> get(String url, Class<T> responseType, Object ... uriVariables) {
        return RestTemplateUtil.getRestTemplate().getForEntity(url, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return RestTemplateUtil.getRestTemplate().exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> sendGetRequest(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) {
        ResponseEntity response = null;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        HttpEntity httpEntity = new HttpEntity(headers);
        try {
            response = RestTemplateUtil.getRestTemplate().exchange(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
        }
        catch (RestClientException e) {
            logger.error("\u8bf7\u6c42" + url + "\u65f6\u65e0\u6cd5\u8fde\u63a5\uff1a", (Object)e.getLocalizedMessage());
        }
        return response;
    }

    public static <T> ResponseEntity<T> sendPostRequest(String url, Object msgBody, Class<T> responseType) {
        ResponseEntity response = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(HEADER, "application/json;charset=UTF-8");
        HttpEntity httpEntity = new HttpEntity(msgBody, (MultiValueMap)headers);
        try {
            response = RestTemplateUtil.getRestTemplate().postForEntity(url, (Object)httpEntity, responseType, new Object[0]);
        }
        catch (RestClientException e) {
            logger.error("\u8bf7\u6c42" + url + "\u65f6\u65e0\u6cd5\u8fde\u63a5\uff1a", (Object)e.getLocalizedMessage());
        }
        return response;
    }

    public static RestTemplate getRestTemplate(int timeout) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(timeout);
        requestFactory.setReadTimeout(timeout);
        RestTemplate restTemp = new RestTemplate();
        restTemp.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemp.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemp;
    }

    public static <I, O> ResponseEntity<O> exchangeWithCustomTemplate(RestTemplate restTemplate, String url, I requestBody, ParameterizedTypeReference<O> responseType, Map<String, String> urlRequestParam, Map<String, String> headerParam, HttpMethod httpMethod) {
        ResponseEntity response = null;
        long start = System.currentTimeMillis();
        logger.info("Rest\u8bf7\u6c42\u5730\u5740:" + url);
        try {
            String requestJson = JSONObject.toJSON(requestBody).toString();
            if (StringUtils.isNotBlank((CharSequence)requestJson) && requestJson.length() > 2000) {
                requestJson = requestJson.substring(0, 2000) + "...";
            }
            logger.info("Rest\u8bf7\u6c42\u53c2\u6570:" + requestJson);
            if (urlRequestParam != null) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
                urlRequestParam.entrySet();
                for (Map.Entry<String, String> e : urlRequestParam.entrySet()) {
                    builder.queryParam(e.getKey(), new Object[]{e.getValue()});
                }
                url = builder.toUriString();
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add(HEADER, "application/json;charset=UTF-8");
            if (headerParam != null) {
                for (Map.Entry<String, String> e : headerParam.entrySet()) {
                    headers.add(e.getKey(), e.getValue());
                }
            }
            if (httpMethod == null) {
                httpMethod = HttpMethod.POST;
            }
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            response = restTemplate.exchange(url, httpMethod, requestEntity, responseType, new Object[0]);
            logger.info("Rest\u8bf7\u6c42\u8017\u65f6:" + (System.currentTimeMillis() - start));
            if (response.getStatusCode().value() == 200) {
                Object respBody = response.getBody();
                String responseJson = GoogleJsonUtil.toJson(respBody);
                if (StringUtils.isNotBlank((CharSequence)responseJson) && responseJson.length() > 1000) {
                    responseJson = responseJson.substring(0, 1000) + "...";
                }
                logger.info("Rest\u8fd4\u56de\u53c2\u6570:" + responseJson);
            } else {
                logger.error("Rest\u8bf7\u6c42" + url + "\u5931\u8d25\uff0c\u72b6\u6001\u7801\u4e3a\uff1a" + response.getStatusCode().value());
            }
        }
        catch (Exception e) {
            logger.info("Rest\u8bf7\u6c42\u8017\u65f6:" + (System.currentTimeMillis() - start));
            logger.error("Rest\u8bf7\u6c42\u5f02\u5e38," + e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public static <I, O> ResponseEntity<O> exchangeIocRestTemplate(String url, I requestBody, ParameterizedTypeReference<O> responseType, Map<String, String> urlRequestParam, Map<String, String> headerParam, HttpMethod httpMethod) {
        return RestTemplateUtil.exchangeWithCustomTemplate(RestTemplateUtil.getRestTemplate(), url, requestBody, responseType, urlRequestParam, headerParam, httpMethod);
    }
}

