/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.ExpUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ThreeCodeFormatUtil {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    private static final Pattern CHINESE_PATTERN = Pattern.compile("[\u4e00-\u9fa5]");
    private static final Pattern ASSEMBLY_PATTERN = Pattern.compile("[\\u4E00-\\u9FA5]+|[A-Za-z]+|\\d+");

    public static String threeCodeFormat(String threeCode) {
        if (StringUtils.isEmpty((CharSequence)threeCode)) {
            return "";
        }
        threeCode = threeCode.trim().replace(" ", "-").toUpperCase();
        threeCode = ThreeCodeFormatUtil.threeCodeChineseResolve(threeCode);
        return threeCode;
    }

    public static final boolean containsChinese(String threeCode) {
        Matcher m = CHINESE_PATTERN.matcher(threeCode);
        return m.find();
    }

    private static String threeCodeChineseResolve(String threeCode) {
        try {
            if (ExpUtils.isBlank(threeCode)) {
                return threeCode;
            }
            if (!ThreeCodeFormatUtil.containsChinese(threeCode)) {
                return threeCode;
            }
            Matcher matcher = ASSEMBLY_PATTERN.matcher(threeCode);
            String datoubi = "";
            while (matcher.find()) {
                datoubi = datoubi + matcher.group(0) + "-";
            }
            String result = datoubi.substring(0, datoubi.length() - 1);
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return threeCode;
        }
    }

    public static String matchCheck(String matchCode) {
        String indexFlag = "-";
        try {
            if (ExpUtils.isBlank(matchCode)) {
                return "";
            }
            String[] str = matchCode.split(indexFlag);
            if (str.length == 4) {
                matchCode = str[1] + indexFlag + str[2];
            } else if (str.length == 3) {
                matchCode = str[1];
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
        return matchCode;
    }
}

