/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.config.UpgradeConfig;
import cn.yto.entity.upgrade.AppUpdateEntity;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.rest.ManageClient;
import cn.yto.rest.newserver.domain.NewServerResp;
import cn.yto.utils.CMDUtil;
import cn.yto.utils.CommonUtils;
import cn.yto.utils.FileUtil;
import cn.yto.utils.SafeProperties;
import cn.yto.utils.YmlFileUtils;
import cn.yto.utils.ZipUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.multipart.MultipartFile;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class UpgradeUtils {
    public static final String UPGRADE_FILE_NAME = "upgrade.properties";
    public static final String APPLICATION_YML_NAME = "application.yml";
    public static final String UPGRADE_KEY_YML = "ymlKey";
    public static final String UPGRADE_KEY_PROPERTIES = "propertiesKey";
    public static final String UPGRADE_KEY_YML_SPECIAL_OLD = "specialOldYmlKey";
    public static final String CONFIG_FILE_PATH = "config";
    public static final String APP_FILENAME_PREFIX = "cv_wcs_";
    public static final String APP_FILENAME_SUFFIX = ".zip";
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static final ThreadLocal<UpgradeConfig> upgradeConfigLocal = new ThreadLocal();
    private static String ACTION = "sign/application/getAppFile";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean modifySettingFiles(File newFile) {
        UpgradeConfig upgradeConfig = UpgradeUtils.getUpgradeConfig(newFile);
        upgradeConfigLocal.set(upgradeConfig);
        File oldFile = null;
        try {
            oldFile = new File(FileUtil.getAppDir());
            boolean modifyPropertiesResult = UpgradeUtils.modifyPropertiesSettingFiles(newFile, oldFile);
            boolean modifyYmlResult = UpgradeUtils.modifyYmlSettingFiles(newFile, oldFile);
            boolean bl = modifyPropertiesResult && modifyYmlResult;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u914d\u7f6e\u5f02\u5e38 new file:{}, old file:{}", new Object[]{newFile, oldFile, e});
            boolean bl = false;
            return bl;
        }
        finally {
            upgradeConfigLocal.remove();
        }
    }

    public static UpgradeConfig getUpgradeConfig(File newFile) {
        File newConfigPath = new File(newFile.getPath() + File.separator + CONFIG_FILE_PATH + File.separator + UPGRADE_FILE_NAME);
        UpgradeConfig upgradeConfig = new UpgradeConfig();
        SafeProperties properties = new SafeProperties();
        try (FileInputStream oldInputStream = new FileInputStream(newConfigPath);){
            properties.load(oldInputStream);
            Set<String> keys = properties.getPropertyNames();
            for (String key : keys) {
                if (UPGRADE_KEY_YML.equals(key)) {
                    upgradeConfig.setYmlKeys(properties.getProperty(key));
                }
                if (UPGRADE_KEY_PROPERTIES.equals(key)) {
                    upgradeConfig.setCommonConfigKeys(properties.getProperty(key));
                }
                if (!UPGRADE_KEY_YML_SPECIAL_OLD.equals(key)) continue;
                upgradeConfig.setSpecialOldYmlKey(properties.getProperty(key));
            }
        }
        catch (IOException e) {
            logger.error("\u89e3\u6790upgrade.properties\u5f02\u5e38 \uff1a{}", (Object)newConfigPath, (Object)e);
        }
        return upgradeConfig;
    }

    public static boolean modifyPropertiesSettingFiles(File newFile, File oldFile) {
        logger.info("=============\u5347\u7ea7\u4fee\u6539config=================");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        File newConfigPath = new File(newFile.getPath() + File.separator + CONFIG_FILE_PATH);
        logger.info("\u65b0config\u8def\u5f84\uff1a{}", (Object)newConfigPath.getPath());
        File oldConfigPath = new File(oldFile.getPath() + File.separator + CONFIG_FILE_PATH);
        logger.info("\u65e7\u7684config\u8def\u5f84\uff1a{}", (Object)oldConfigPath.getPath());
        File[] newConfigFiles = newConfigPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        if (newConfigFiles == null || newConfigFiles.length == 0) {
            logger.info("\u65b0config\u8def\u5f84\u4e2d\u65e0properties\u6587\u4ef6");
            return false;
        }
        for (File newConfigFile : newConfigFiles) {
            File oldConfigFile;
            String configFileName = newConfigFile.getName();
            if (configFileName.toLowerCase().startsWith("upgrade") || !(oldConfigFile = new File(oldConfigPath.getPath() + File.separator + configFileName)).exists()) continue;
            SafeProperties newProperties = new SafeProperties();
            SafeProperties oldProperties = new SafeProperties();
            try (FileInputStream newInputStream = new FileInputStream(newConfigFile);
                 FileInputStream oldInputStream = new FileInputStream(oldConfigFile);){
                newProperties.load(newInputStream);
                oldProperties.load(oldInputStream);
                Set<String> keys = newProperties.getPropertyNames();
                for (String key : keys) {
                    String oldProperty = oldProperties.getProperty(key);
                    if (!StringUtils.isNotBlank((CharSequence)oldProperty) || upgradeConfigLocal.get().containsCommonKey(key)) continue;
                    newProperties.setProperty(key, oldProperty);
                }
                CommonUtils.saveProperties(newProperties, newConfigFile.getPath(), null);
                logger.info("\u5904\u7406properties\u6587\u4ef6\u5b8c\u6210\uff1a{}", (Object)newConfigFile.getAbsolutePath());
            }
            catch (IOException e) {
                logger.error("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6" + newConfigFile.getPath() + "\u51fa\u9519", (Throwable)e);
            }
        }
        stopWatch.stop();
        logger.info("\u5347\u7ea7copy properties\u6587\u4ef6\u7ed3\u675f,\u7528\u65f6{}", (Object)stopWatch.getTotalTimeMillis());
        return true;
    }

    public static boolean modifyYmlSettingFiles(File newFile, File oldFile) {
        logger.info("=============\u5347\u7ea7\u4fee\u6539application.yml=================");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        File newYmlPath = new File(newFile.getPath() + File.separator + APPLICATION_YML_NAME);
        logger.info("\u65b0yml\u6587\u4ef6\uff1a{}", (Object)newYmlPath.getPath());
        File oldYmlPath = new File(oldFile.getPath() + File.separator + APPLICATION_YML_NAME);
        logger.info("\u65e7yml\u6587\u4ef6\uff1a{}", (Object)oldYmlPath.getPath());
        try (FileInputStream newInputStream = new FileInputStream(newYmlPath);
             FileInputStream oldInputStream = new FileInputStream(oldYmlPath);
             InputStreamReader newInputStreamReader = new InputStreamReader((InputStream)newInputStream, StandardCharsets.UTF_8);
             InputStreamReader oldInputStreamReader = new InputStreamReader((InputStream)oldInputStream, StandardCharsets.UTF_8);
             FileOutputStream fileOutputStream = new FileOutputStream(newYmlPath, true);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
             BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);){
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml newYaml = new Yaml(options);
            Yaml oldYaml = new Yaml();
            Map newYmlMap = (Map)newYaml.loadAs((Reader)newInputStreamReader, Map.class);
            Map oldYmlMap = (Map)oldYaml.loadAs((Reader)oldInputStreamReader, Map.class);
            UpgradeUtils.recursionMap(newYmlMap, oldYmlMap);
            logger.info("\u5f00\u59cb\u6301\u4e45\u5316\u65b0yml...");
            UpgradeUtils.clearInfoForFile(newYmlPath.getPath());
            newYaml.dump((Object)newYmlMap, (Writer)bufferedWriter);
            logger.info("\u6301\u4e45\u5316\u65b0yml\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6" + newYmlPath.getPath() + "\u51fa\u9519", (Throwable)e);
            return false;
        }
        stopWatch.stop();
        logger.info("\u5347\u7ea7copy yml\u6587\u4ef6\u7ed3\u675f,\u7528\u65f6{}", (Object)stopWatch.getTotalTimeMillis());
        return true;
    }

    public static void clearInfoForFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("");
        fileWriter.flush();
        fileWriter.close();
        logger.info("\u5df2\u6e05\u7a7a\u6587\u4ef6\uff1a{}", (Object)fileName);
    }

    private static void recursionMap(Map<String, Object> newYmlMap, Map<String, Object> oldYmlMap) {
        List<String> newYmlKeyChains = YmlFileUtils.getAllKeyChains(newYmlMap);
        for (String keyChain : newYmlKeyChains) {
            Object oldValue;
            if (upgradeConfigLocal.get().containsYmlKey(keyChain) || (oldValue = YmlFileUtils.getValue(oldYmlMap, keyChain, false)) == null) continue;
            YmlFileUtils.setMapValue(newYmlMap, keyChain, oldValue);
        }
        List<String> specialOldYmlKeys = upgradeConfigLocal.get().getSpecialOldYmlKey();
        if (!CollectionUtils.isEmpty(specialOldYmlKeys)) {
            for (String specialOldYmlKey : specialOldYmlKeys) {
                Object newValue = YmlFileUtils.getValue(newYmlMap, specialOldYmlKey, false);
                Object oldValue = YmlFileUtils.getValue(oldYmlMap, specialOldYmlKey, false);
                if (newValue == null || oldValue == null) continue;
                logger.info("\u7279\u6b8aymlkey\u7ee7\u627f\u65e7\u914d\u7f6ekey: {}", (Object)specialOldYmlKey);
                YmlFileUtils.setMapValue(newYmlMap, specialOldYmlKey, oldValue);
            }
        }
    }

    public static File unZipAppFile(File newAppFile, String targetDir) {
        try {
            ZipUtil.unZip(newAppFile, targetDir);
            UpgradeUtils.coverBatFile(targetDir);
            return new File(targetDir);
        }
        catch (IOException e) {
            logger.error("\u89e3\u538bZip\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static void coverBatFile(String filePath) throws IOException {
        File destDir = new File(filePath);
        File oldFile = new File(FileUtil.getAppDir());
        for (File file : oldFile.listFiles()) {
            if (file.isDirectory() || !file.getName().toLowerCase().equals("exp_wcs.xml")) continue;
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    public static File saveAppFileToLocalDisk(MultipartFile file) {
        try {
            File appFile = new File(FileUtil.getUpgradePkgWcsDir() + File.separator + file.getOriginalFilename());
            FileUtils.deleteQuietly((File)appFile);
            file.transferTo(appFile);
            return appFile;
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static File getNewAppFromLocal(String version) {
        return new File(FileUtil.getUpgradePkgWcsDir() + File.separator + APP_FILENAME_PREFIX + version + APP_FILENAME_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveAppFileToTemp(byte[] file, String fileName) {
        File[] files;
        File file2;
        String directoryPath = FileUtil.getUpgradePkgWcsDir();
        File appFile = new File(directoryPath + File.separator + fileName);
        try {
            FileUtils.writeByteArrayToFile((File)appFile, (byte[])file);
            file2 = appFile;
            files = new File(directoryPath).listFiles(new FileFilter(appFile){
                final /* synthetic */ File val$appFile;
                {
                    this.val$appFile = file;
                }

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && !pathname.getName().equals(this.val$appFile.getName()) && pathname.getName().startsWith(UpgradeUtils.APP_FILENAME_PREFIX) && pathname.getName().endsWith(UpgradeUtils.APP_FILENAME_SUFFIX);
                }
            });
        }
        catch (IOException e) {
            File[] files2;
            File file3;
            try {
                logger.error("\u4fdd\u5b58\u6587\u4ef6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                file3 = null;
                files2 = new File(directoryPath).listFiles(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                File[] files3 = new File(directoryPath).listFiles(new /* invalid duplicate definition of identical inner class */);
                if (files3 != null && files3.length > 0) {
                    for (File file1 : files3) {
                        if (FileUtils.deleteQuietly((File)file1)) {
                            logger.info("\u5220\u9664\u65e7\u6587\u4ef6\uff1a{}", (Object)file1.getAbsolutePath());
                            continue;
                        }
                        logger.info("\u5220\u9664\u65e7\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)file1.getAbsolutePath());
                    }
                }
                throw throwable;
            }
            if (files2 != null && files2.length > 0) {
                for (File file1 : files2) {
                    if (FileUtils.deleteQuietly((File)file1)) {
                        logger.info("\u5220\u9664\u65e7\u6587\u4ef6\uff1a{}", (Object)file1.getAbsolutePath());
                        continue;
                    }
                    logger.info("\u5220\u9664\u65e7\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)file1.getAbsolutePath());
                }
            }
            return file3;
        }
        if (files != null && files.length > 0) {
            for (File file1 : files) {
                if (FileUtils.deleteQuietly((File)file1)) {
                    logger.info("\u5220\u9664\u65e7\u6587\u4ef6\uff1a{}", (Object)file1.getAbsolutePath());
                    continue;
                }
                logger.info("\u5220\u9664\u65e7\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)file1.getAbsolutePath());
            }
        }
        return file2;
    }

    public static File saveAppFileToLocalDisk(byte[] fileByte, String file) {
        File appFile = new File(file);
        if (!appFile.getParentFile().exists() && !appFile.getParentFile().mkdirs()) {
            logger.error("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff1a{}", (Object)appFile.getParentFile());
        }
        if (appFile.exists() && appFile.isFile() && !appFile.delete()) {
            logger.error("\u65e7\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a{}", (Object)appFile);
        }
        try (FileOutputStream fos = new FileOutputStream(appFile);){
            fos.write(fileByte);
            fos.flush();
        }
        catch (IOException e) {
            logger.error("\u672c\u5730\u5199\u6587\u4ef6IO\u5f02\u5e38", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error("\u672c\u5730\u5199\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return appFile;
    }

    public static String createUnzipDir(String version, String oldVersion) {
        File localAppFile = new File(FileUtil.getAppDir());
        String newAppPathName = localAppFile.getName();
        try {
            if (localAppFile.getName().endsWith(oldVersion)) {
                newAppPathName = localAppFile.getName().substring(0, localAppFile.getName().lastIndexOf("_"));
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u65b0\u7248\u672c\u5e94\u7528\u7684\u90e8\u7f72\u8def\u5f84\u5931\u8d25", (Throwable)e);
        }
        return localAppFile.getParent() + File.separator + newAppPathName + "_" + version;
    }

    public static String getRestartScriptName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "restart.bat";
        }
        return "restart.sh";
    }

    public static void downloadAppNewWay(Map<String, Object> appInfoMap, AppUpdateEntity msgBody) {
        logger.info("\u5f00\u59cb\u4f7f\u7528\u65b0\u63a5\u53e3\u4e0b\u8f7d\u5b89\u88c5\u5305...");
        long l = System.currentTimeMillis();
        NewServerResp<JSONObject> response = ManageClient.doRequest2(300000, msgBody, ACTION, new ParameterizedTypeReference<ManageClient.ManagePlatResp<JSONObject>>(){});
        try {
            if ("200".equals(response.getCode())) {
                long l1 = System.currentTimeMillis();
                logger.info("\u4ece\u65b0\u7684\u63a5\u53e3\u4e0b\u8f7d\u5230\u6587\u4ef6\u6210\u529f\u8017\u65f6:{}", (Object)(l1 - l));
                JSONObject jsonObject = response.getData();
                String fileName = jsonObject.getString("fileName");
                appInfoMap.put("appBinary", jsonObject.getBytes("file"));
                appInfoMap.put("appFileName", fileName);
                appInfoMap.put("appVersion", jsonObject.getString("appVersion"));
                logger.info("\u5b57\u7b26\u4e32\u8f6c\u5b57\u8282\u6570\u7ec4\u5b8c\u6210,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - l1));
            } else {
                logger.error("\u65b0\u4e0b\u8f7d\u6587\u4ef6\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38:{}", (Object)JSONObject.toJSONString(response));
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u63a5\u53e3\u4e0b\u8f7d\u5b89\u88c5\u5305\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void restartApp(String appPath, String port) {
        appPath = appPath + File.separator;
        String restartScript = appPath + UpgradeUtils.getRestartScriptName();
        String finalAppPath = appPath;
        new Thread(() -> {
            try {
                Thread.sleep(1600L);
            }
            catch (InterruptedException e) {
                logger.error("\u672a\u80fd\u5ef6\u8fdf\u91cd\u542f");
            }
            logger.info("\u91cd\u542f\u811a\u672c\uff1a{}", (Object)restartScript);
            if (SystemUtils.IS_OS_WINDOWS) {
                logger.info("\u6267\u884cwindows\u91cd\u542f\u811a\u672c");
                CMDUtil.excuteBatFile(restartScript, port, finalAppPath);
            } else {
                logger.info("\u6267\u884clinux\u91cd\u542f\u811a\u672c");
                String s = CMDUtil.excuteShFile(restartScript, System.getProperty("java.home"));
                logger.info("\u6267\u884c\u7ed3\u679c\uff1a" + s);
            }
        }).start();
    }
}

