/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.log.CustomLoggerFactory;
import com.alibaba.fastjson.JSONObject;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YmlFileUtils {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    public static final DumperOptions YML_OPTIONS = new DumperOptions();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setValue(Map<String, Object> keyAndValue, String ymlFilePath, boolean append) {
        if (CollectionUtils.isEmpty(keyAndValue)) return false;
        if (StringUtils.isBlank((CharSequence)ymlFilePath)) {
            return false;
        }
        Yaml yaml = new Yaml(YML_OPTIONS);
        Map<String, Object> yamlMap = YmlFileUtils.loadAsMap(ymlFilePath, yaml);
        if (CollectionUtils.isEmpty(yamlMap)) {
            return false;
        }
        Iterator<Map.Entry<String, Object>> iterator = keyAndValue.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            Object newValue = next.getValue();
            Object oldVal = YmlFileUtils.getValue(yamlMap, next.getKey(), append);
            if (null != oldVal && !(oldVal instanceof Map) && newValue != null && !oldVal.equals(newValue)) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty(keyAndValue)) {
            return false;
        }
        try (FileOutputStream outputStream = new FileOutputStream(ymlFilePath);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
            Map<String, Object> resultMap = null;
            for (Map.Entry<String, Object> entry : keyAndValue.entrySet()) {
                resultMap = YmlFileUtils.setMapValue(yamlMap, entry.getKey(), entry.getValue());
            }
            if (resultMap == null) return false;
            yaml.dump(resultMap, (Writer)outputStreamWriter);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539yml\u914d\u7f6e\u5f02\u5e38,path:{},param:{}", new Object[]{ymlFilePath, JSONObject.toJSONString(keyAndValue), e});
        }
        return false;
    }

    public static boolean setValue(String keyChain, Object value, String ymlFilePath, boolean append) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(1);
        linkedHashMap.put(keyChain, value);
        return YmlFileUtils.setValue(linkedHashMap, ymlFilePath, append);
    }

    public static Map<String, Object> setMapValue(Map<String, Object> yamlMap, String keyChain, Object value) {
        String[] keys = keyChain.split("\\.");
        int len = keys.length;
        Map temp = yamlMap;
        for (int i = 0; i < len - 1; ++i) {
            if (!temp.containsKey(keys[i])) {
                return null;
            }
            temp = (Map)temp.get(keys[i]);
            if (i != len - 2) continue;
            temp.put(keys[i + 1], value);
        }
        for (int j = 0; j < len - 1; ++j) {
            if (j != len - 1) continue;
            yamlMap.put(keys[j], temp);
        }
        return yamlMap;
    }

    public static Object getValue(Map<String, Object> yamlMap, String keyChain, boolean append) {
        String[] keys = keyChain.split("[.]");
        Object o = yamlMap.get(keys[0]);
        if (keyChain.contains(".")) {
            if (o instanceof Map) {
                return YmlFileUtils.getValue((Map)o, keyChain.substring(keyChain.indexOf(".") + 1), append);
            }
            return null;
        }
        if (yamlMap.containsKey(keyChain) || append) {
            return o == null ? "" : o;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Object> loadAsMap(String ymlFilePath, Yaml yaml) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getAllKeyChains(Map<String, Object> ymlMap) {
        ArrayList<String> keyChains = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : ymlMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                for (String subKeyChain : YmlFileUtils.getAllKeyChains((Map)value)) {
                    keyChains.add(key + "." + subKeyChain);
                }
                continue;
            }
            keyChains.add(key);
        }
        return keyChains;
    }

    public static void main(String[] args) throws IOException {
        String newYml = "D:\\project\\test\\application-pro-new.yml";
        String oldYml = "D:\\project\\test\\application-pro-old.yml";
        ArrayList<String> keyChains = new ArrayList<String>();
        keyChains.add("swagger.title");
        keyChains.add("swagger.contact");
        keyChains.add("swagger.version");
        keyChains.add("mybatis-plus.global-config.db-config.logic-delete-value");
        keyChains.add("monitor.downloadServer.url");
        keyChains.add("monitor.newserverLogin.url");
        Yaml yaml = new Yaml(YML_OPTIONS);
        Map<String, Object> newYmlMap = YmlFileUtils.loadAsMap(newYml, yaml);
        Map<String, Object> oldYmlMap = YmlFileUtils.loadAsMap(oldYml, new Yaml(YML_OPTIONS));
        List<String> allKeyChains = YmlFileUtils.getAllKeyChains(oldYmlMap);
        for (String s1 : allKeyChains) {
            if (keyChains.contains(s1)) continue;
            YmlFileUtils.setMapValue(newYmlMap, s1, YmlFileUtils.getValue(oldYmlMap, s1, false));
        }
        try (FileWriter fileWriter = new FileWriter(newYml);){
            yaml.dump(newYmlMap, (Writer)fileWriter);
        }
        System.out.println();
    }

    static {
        YML_OPTIONS.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        YML_OPTIONS.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
    }
}

