/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.log.CustomLoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;

public class ZipUtil {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();

    public static void unZip(String sourceFilePath, String targetDir) throws IOException {
        ZipUtil.unZip(new File(sourceFilePath), targetDir);
    }

    public static void unZip(File sourceFile, String targetDir) throws IOException {
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("cannot find the file = " + sourceFile.getPath());
        }
        long start = System.currentTimeMillis();
        try (ZipFile zipFile = new ZipFile(sourceFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName().substring(entry.getName().indexOf("/") + 1);
                String dirPath = targetDir + File.separator + name;
                if (entry.isDirectory()) {
                    ZipUtil.createDirIfNotExist(dirPath);
                    continue;
                }
                File targetFile = new File(dirPath);
                ZipUtil.createFileIfNotExist(targetFile);
                InputStream is = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream fos = new FileOutputStream(targetFile);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buf = new byte[1024];
                        while ((len = is.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            logger.info("\u89e3\u538b" + sourceFile.getPath() + "\u81f3" + targetDir + "\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public static void createDirIfNotExist(String path) {
        File file = new File(path);
        ZipUtil.createDirIfNotExist(file);
    }

    public static void createDirIfNotExist(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void createFileIfNotExist(File file) throws IOException {
        ZipUtil.createParentDirIfNotExist(file);
        file.createNewFile();
    }

    public static void createParentDirIfNotExist(File file) {
        ZipUtil.createDirIfNotExist(file.getParentFile());
    }
}

