<%@ page language="java" pageEncoding="UTF-8" %>

<style type="text/css">
    .show-filed-div{
        border-bottom: 1px solid #CCC;
        height: 30px;
        line-height: 30px;
        padding: 0 10px;
    }
    .show-filed-hover:hover{
        background: #F4EAF9;
    }
    .show-filed-icon{
        float: right;
    }
</style>
<script>
    var domId = '';
    function initDatagridFiled(domId){
        var pager = $('#'+domId).datagrid().datagrid('getPager');	// get the pager of datagrid
        pager.pagination({
            buttons:[{
                iconCls:'iconfont common-exchange4',
                handler:function(){
                    editFiled(domId);
                }
            }]
        });
        tableFiledChange(domId);
    }
    function tableFiledChange(domId) {
        //var key = domId+"_"+permissionCode;
        if(!storage.get("tableFiled") || !storage.get("tableFiled")[domId]){
            return;
        }
        var tableFileds = storage.get("tableFiled")[domId];
        var newCol = tableFileds.newColumns;
        var oldCol = tableFileds.oldColumns;
        if(newCol && newCol.length>0){
            for(var i=0; i<newCol.length; i++){
                $('#'+domId).datagrid('showColumn',newCol[i].field);
            }
        }
        if(oldCol && oldCol.length>0){
            for(var i=0; i<oldCol.length; i++){
                $('#'+domId).datagrid('hideColumn',oldCol[i].field);
            }
        }
    }
    function editFiled(domId) {
        var columns = $('#'+domId).datagrid('options').columns[0];
        var add = document.getElementById('newFiled');
        var remove = document.getElementById('oldFiled');
        //var domId = domId+"_"+permissionCode;
        if(!storage.get("tableFiled")){
            storage.set("tableFiled",{});
        }
        var tableFileds = storage.get("tableFiled")[domId];
        tableFileds = tableFileds || {};
        tableFileds.oldColumns = tableFileds.oldColumns || [];
        tableFileds.newColumns = tableFileds.newColumns || columns;
        while(add.hasChildNodes()) {
            add.removeChild(add.firstChild);
        }
        while(remove.hasChildNodes()) {
            remove.removeChild(remove.firstChild);
        }
        if(tableFileds.newColumns && tableFileds.newColumns.length>0){
            for(var i=0; i<tableFileds.newColumns.length; i++){
                var filed = tableFileds.newColumns[i];
                var divDom = document.createElement('div');
                divDom.setAttribute('class',"show-filed-div show-filed-hover");

                divDom.innerHTML = filed.title +
                    "<a onclick='removeDiv(this,domId)' class='iconfont common-minus_crude show-filed-icon'></a>" ;
                add.appendChild(divDom)
            }
        }
        if(tableFileds.oldColumns && tableFileds.oldColumns.length>0){
            for(var i=0; i<tableFileds.oldColumns.length; i++){
                var filed = tableFileds.oldColumns[i];
                var divDom = document.createElement('div');
                divDom.setAttribute('class',"show-filed-div show-filed-hover");

                divDom.innerHTML = filed.title +
                    "<a onclick='addDiv(this,domId)' class='iconfont common-add_crude show-filed-icon'></a>" ;
                remove.appendChild(divDom)
            }
        }
        var data = storage.get("tableFiled");
        data[domId] = tableFileds;
        storage.set("tableFiled",data);
        this.domId = domId;
        openDialog("dialogEditFiled", '选择列');
    }
    function remveAdd(title) {
        var tableFileds = storage.get("tableFiled")[domId];
        var newCol = tableFileds.newColumns;
        var oldCol = tableFileds.oldColumns;
        var col = [];
        if(newCol && newCol.length>0){
            for(var i=0; i<newCol.length; i++){
                if(newCol[i].title == title){
                    oldCol.push(newCol[i])
                    continue;
                }
                col.push(newCol[i])
            }
        }
        tableFileds.newColumns = col;
        var data = storage.get("tableFiled");
        data[domId] = tableFileds;
        storage.set("tableFiled",data);
    }
    function addRemove(title) {
        //var domId = "role_table_role"
        var tableFileds = storage.get("tableFiled")[domId];
        var oldCol = tableFileds.newColumns;
        var newCol = tableFileds.oldColumns;
        var col = [];
        if(newCol && newCol.length>0){
            for(var i=0; i<newCol.length; i++){
                if(newCol[i].title == title){
                    oldCol.push(newCol[i])
                    continue;
                }
                col.push(newCol[i])
            }
        }
        tableFileds.oldColumns = col;
        var data = storage.get("tableFiled");
        data[domId] = tableFileds;
        storage.set("tableFiled",data);
    }
    function removeDiv(test){
        test.parentNode.parentNode.removeChild(test.parentNode);
        var add = document.getElementById('oldFiled');
        var divDom = document.createElement('div');
        divDom.setAttribute('class',"show-filed-div show-filed-hover");
        remveAdd(test.parentNode.innerText);
        divDom.innerHTML = test.parentNode.innerText +
            "<a onclick='addDiv(this)' class='iconfont common-add_crude show-filed-icon'></a>" ;
        add.appendChild(divDom)
    }
    function addDiv(test){
        test.parentNode.parentNode.removeChild(test.parentNode);
        var add = document.getElementById('newFiled');
        var divDom = document.createElement('div');
        divDom.setAttribute('class',"show-filed-div show-filed-hover");
        addRemove(test.parentNode.innerText)
        divDom.innerHTML = test.parentNode.innerText +
            "<a onclick='removeDiv(this)' class='iconfont common-minus_crude show-filed-icon'></a>" ;
        add.appendChild(divDom)
    }
    function saveFiled() {
        //var domId = "role_table_role"
        var tableFileds = storage.get("tableFiled")[domId];
        var newCol = tableFileds.newColumns;
        var oldCol = tableFileds.oldColumns;
        if(newCol && newCol.length>0){
            for(var i=0; i<newCol.length; i++){
                $('#'+domId).datagrid('showColumn',newCol[i].field);
            }
        }
        if(oldCol && oldCol.length>0){
            for(var i=0; i<oldCol.length; i++){
                $('#'+domId).datagrid('hideColumn',oldCol[i].field);
            }
        }
        closeDialog('dialogEditFiled');
    }

    function cancleFiled() {
        closeDialog('dialogEditFiled');
    }

</script>

<div id="dialogEditFiled" class="easyui-dialog" style="width: 500px; height:600px;" closed="true" buttons="#dialogEditFiledButtons">
    <div id="cc" class="easyui-layout" style="width:100%;height:100%;">
        <div data-options="region:'east',title:'隐藏列',split:true,collapsible:false" style="width:49%;height: 500px" id="oldFiled"></div>
        <div data-options="region:'west',title:'显示列',split:true,collapsible:false" style="width:49%;height: 500px" id="newFiled"></div>
    </div>

</div>
<div id="dialogEditFiledButtons">
    <a href="javascript:void(0)" onclick="saveFiled()" class="easyui-linkbutton save">保存</a>
    <a href="javascript:void(0)" onclick="cancleFiled()" class="easyui-linkbutton call">取消</a>
</div>