
var metaChar = '[\\[\\]\\\\\^\\$\\.\\|\\?\\*\\+\\(\\)]'; //js正则表达式元字符集
var rexMeta = new RegExp(metaChar, 'gi');//匹配元字符的正则表达式
var zTreeObj = null
var config = {
    isHighLight: true, // 是否高亮,默认高亮,传入false禁用
    nameKey: '',
    isExpand: false // 是否展开,默认合拢,传入true展开
}
/**
 *
 * @param zTreeId ztree对象的id,不需要#
 * @param isHighLight 是否高亮,默认高亮,传入false禁用
 * @param isExpand 是否展开,默认合拢,传入true展开
 * @returns
 */
function fuzzySearch(zTreeId, option) {
    zTreeObj = null;
    zTreeObj = $.fn.zTree.getZTreeObj(zTreeId);//获取树对象
    if (!zTreeObj) {
        alter("获取树对象失败");
    }
    $.extend(config, {
        nameKey: zTreeObj.setting.data.key.name
    }, option || {})
}
/**
 * 对符合条件的节点做二次处理
 */
function processShowNodes(nodesShow, _keywords) {
    if (nodesShow && nodesShow.length > 0) {
        //关键字不为空时对关键字节点的祖先节点进行二次处理
        if (_keywords.length > 0) {
            $.each(nodesShow, function (n, obj) {
                var pathOfOne = obj.getPath();//向上追溯,获取节点的所有祖先节点(包括自己)
                if (pathOfOne && pathOfOne.length > 0) {
                    // i < pathOfOne.length-1, 对节点本身不再操作
                    for (var i = 0; i < pathOfOne.length - 1; i++) {
                        zTreeObj.showNode(pathOfOne[i]); //显示节点
                        zTreeObj.expandNode(pathOfOne[i], true); //展开节点
                    }
                }
            });
        } else { //关键字为空则显示所有节点, 此时展开根节点
            var rootNodes = zTreeObj.getNodesByParam('level', '0');//获得所有根节点
            $.each(rootNodes, function (n, obj) {
                zTreeObj.expandNode(obj, true); //展开所有根节点
            });
        }
    }
}

function matchCallback(node, _keywords) {
    if (isEmpty(_keywords)) { return }
    if (config.isHighLight === true) { //如果高亮，对文字进行高亮处理
        //创建一个新变量newKeywords,不影响_keywords在下一个节点使用
        //对_keywords中的元字符进行处理,否则无法在replace中使用RegExp
        var newKeywords = _keywords.replace(rexMeta, value => '\\' + value);
        node.oldname = node[config.nameKey]; //缓存原有名称用于恢复
        //为处理过元字符的_keywords创建正则表达式,全局且不分大小写
        var rexGlobal = new RegExp(newKeywords, 'gi');//'g'代表全局匹配,'i'代表不区分大小写
        //无法直接使用replace(/substr/g,replacement)方法,所以使用RegExp
        node[config.nameKey] = node.oldname.replace(rexGlobal, value => {
            var highLightText =
                '<span style="color: whitesmoke;background-color: darkred;">'
                + value
                + '</span>';
            return highLightText;
        });
        zTreeObj.updateNode(node); //update让更名和高亮生效
    }
}

// 过滤ztree显示数据
function ztreeFilter(zTreeObj, _keywords) {
    if (isEmpty(_keywords)) { _keywords = '' }
    let target = {}
    if (typeClass.isString(_keywords)) {
        Object.assign(target, { keyword: _keywords })
    } else {
        Object.assign(target, _keywords)
    }
    // 查找符合条件的叶子节点
    function filterFunc(node) {
        if (node && node.oldname && node.oldname.length > 0) {
            node[config.nameKey] = node.oldname; //如果存在原始名称则恢复原始名称
        }
        //node.highlight = false; //取消高亮
        zTreeObj.updateNode(node); //更新节点让之前对节点所做的修改生效

        let flag = true
        let nameValue = node[config.nameKey]
        nameValue = isEmpty(nameValue) ? '' : nameValue.toLowerCase()
        for (const key in target) {
            const value = target[key]
            if (isEmpty(value)) { continue }
            const lowerCaseValue = value.toLowerCase()
            if (key !== 'keyword') {
                if (node[key] && node[key].toLowerCase() !== lowerCaseValue) {
                    flag = false; break
                }
                continue
            }
            if (nameValue.indexOf(lowerCaseValue) === -1) {
                flag = false; break
            }
        }

        if (flag === true) {
            matchCallback(node, target['keyword'])
            zTreeObj.showNode(node);//显示符合条件的节点
            return true
        }

        zTreeObj.hideNode(node); // 隐藏不符合要求的节点
        return false; //不符合返回false
    }
    var nodesShow = zTreeObj.getNodesByFilter(filterFunc); //获取匹配关键字的节点
    processShowNodes(nodesShow, target['keyword']);//对获取的节点进行二次处理
}

var timeoutId = null;
function searchNodeLazy(newValue) {
    if (timeoutId) { //如果不为空,结束任务
        clearTimeout(timeoutId);
    }
    timeoutId = setTimeout(function () {
        ztreeFilter(zTreeObj, newValue);    //延时执行筛选方法
        $(this).focus();//输入框重新获取焦点
    }, 500);
}

var resultFlag = false;

var zParams = {};
/**
 * @description: 自定义过滤ztree节点
 * @param zTreeId 树domid
 * @param params 过滤条件
 * @return
 * @throws
 * @author ZQ
 * @date 2019/8/9 11:05
 */
function fillterZtreeNodes(zTreeId,params) {
    if(resultFlag){return}
    resultFlag = true;
    $(".common-tree-loading").addClass("tree-loading")
    if(typeClass.isString(params)){
        return;
    }

    zParams = params;
    if(!zTreeId){
        console.log("treeId为空");
        return;
    }
    var zTreeObj = $.fn.zTree.getZTreeObj(zTreeId);//获取树对象

    if (!zTreeObj) {
        console.log("树对象获取为空");
        return;
    }
    if(isEmptyObject(params)){
        zTreeObj.showNodes(zTreeObj.getNodes());
        return;
    }
    zTreeObj.hideNodes(zTreeObj.getNodes());
    //获取匹配关键字的节点
    var nodesShow = zTreeObj.getNodesByFilter(filterNodeFunc);
    showMatchNodes(zTreeObj,nodesShow);
    $(".common-tree-loading").removeClass("tree-loading")
    resultFlag = false;
}

// 自定义过滤方法
function filterNodeFunc(node) {
    if(node.name.indexOf('span'!=-1)){
        node.name = node.name.replace('<span style="color: red">','');
        node.name = node.name.replace('</span>','');
    }

    for (const key in zParams) {
        const value = zParams[key]
        if (isEmpty(value)) { continue }
        const lowerCaseValue = value.toLowerCase()
        if (node[key] && node[key].toLowerCase().indexOf(value)===-1) {
            zTreeObj.updateNode(node);
            zTreeObj.hideNode(node);
            return false;
        }
        node.name = '<span style="color: red">'+node.name + '</span>'
        zTreeObj.updateNode(node);
        zTreeObj.showNode(node);
        return true;
    }
}

function showMatchNodes(zTreeObj,nodes) {
    if(nodes && nodes.length>0){
        $.each(nodes, function (n, obj) {
            var pathOfOne = obj.getPath();//向上追溯,获取节点的所有祖先节点(包括自己)
            if (pathOfOne && pathOfOne.length > 0) {
                // i < pathOfOne.length-1, 对节点本身不再操作
                for (var i = 0; i < pathOfOne.length - 1; i++) {
                    zTreeObj.showNode(pathOfOne[i]); //显示节点
                    zTreeObj.expandNode(pathOfOne[i], true); //展开节点
                }
            }
        });
    }
}




