(function($){
		var combogridPlugin = $.fn.combogrid;
		$.fn.commonCombogrid = function(options, param){
	    	if(typeof options == "string"){
		    	return $.fn.combogrid.apply(this,arguments);
	    	}
	    	options = options||{};
	    	return this.each(function(){
	    		var commonOpts = $.extend({},$.fn.commonCombogrid.defaults,$.fn.commonCombogrid.parseOptions(this), options);
	    		if (!commonOpts.filterFields) {
	    			commonOpts.filterFields = commonOpts.textField;
	    		}
	    		if (typeof commonOpts.filterFields == "string") {
	    			commonOpts.filterFields = [commonOpts.filterFields];
	    		}
	    		$.fn.combogrid.call($(this), commonOpts);
	    	});
    	};
	    $.fn.commonCombogrid.methods = combogridPlugin.methods;
	    $.fn.commonCombogrid.parseData = combogridPlugin.parseData;
	  //解析自定义属性：queryParamName-当mode = 'remote'时，用户搜索数据时，grid重新请求数据的参数名称
	    //<!-- filterFields : 输入时，根据什么字段过滤 -->
	    //<!-- limitToList : 限制只能选择列表内的数据，默认true -->
	    // <!-- frontPage : 在前端分页，后台load data时加载所有数据，只在mode != 'remote'时有效 -->
	    //queryMinCharLength: 当输入字符长度达到最小值时，才发起后台查询，默认为3
	    $.fn.commonCombogrid.parseOptions = function(options){
			 return $.extend({}, combogridPlugin.parseOptions(options), $.parser.parseOptions(options,["queryParamName", "limitToList", "filterFields", "frontPage", 'queryMinCharLength']));
		}
	   
		$.fn.commonCombogrid.defaults = $.extend({}, $.fn.combogrid.defaults,{
			queryParamName : "keyword", //设置默认请求参数名称：keyword
			limitToList : true, //默认设置limitToList = true， 只允许选择列表内的数据
			frontPage : true,
			queryMinCharLength : 1,
			//当mode = 'local'时，在前端分页，只显示当页数据
			loadFilter : function(data) {
				var dg = $(this);
				return pageData(dg, data);
			},
			keyHandler : $.extend({}, combogridPlugin.defaults.keyHandler, {
				//用户输入时，过滤数据
				query : function(keyword, e) {
					var target = e.data.target;
					var combo = $(target);
					var mode = combo.commonCombogrid("options").mode;// 是否远程请求数据
					query(combo, keyword);
					if (mode != 'remote') {
						if (combogridPlugin.defaults.keyHandler && combogridPlugin.defaults.keyHandler.query) {
							combogridPlugin.defaults.keyHandler.query.call(this, keyword, e);
						}
					}
				}
			}) ,
			filter : function(keyword, row) {
				return filter(this, keyword, row);
			},
			//panel隐藏时，判断选择的数据是否是在列表内，如果不在列表内，清空文本框
			onHidePanel : function() {
				limitValueInCombogridList(this);
				if (combogridPlugin.onHidePanel) {
					combogridPlugin.onHidePanel.call(this);
				}
			}
		});
		
		function pageData(dg, data) {
			var options = dg.datagrid("options");
			var mode = options.mode;// 是否远程请求数据
            var frontPage = options.frontPage;// 是否在前端实现分页功能
			if (mode != 'remote' && frontPage) {
				if (typeof data.length == 'number' && typeof data.splice == 'function') {
	                data = {
	                    total: data.length,
	                    rows: data
	                }
	            }
				var pager = dg.datagrid('getPager');
				//设置分页数、每页显示记录条数
	            pager.pagination({
	                onSelectPage:function(pageNum, pageSize){
	                	options.pageNumber = pageNum;
	                    pager.pagination('refresh',{
	                        pageNumber:pageNum,
	                        pageSize:pageSize
	                    });
	                    dg.datagrid('loadData',data);
	                }
	            });
	            if (!$.data(dg[0], 'allRows')) {//datagrid 所有数据
	            	$.data(dg[0], 'allRows', data.rows);
	            }
	            if (!$.data(dg[0], 'originalRows')) {//当前查询条件下所有数据
	            	$.data(dg[0], 'originalRows', data.rows);
	            }
				//获取当页数据
				var start = (options.pageNumber - 1) * parseInt(options.pageSize);
	            var end = start + parseInt(options.pageSize);
	            data.rows = $.data(dg[0], 'originalRows').slice(start, end);
	            return data;
			}
			return data;
		}
		
		function query(combo, keyword) {
			var comgrid = combo.commonCombogrid("grid");
			var mode = combo.commonCombogrid("options").mode;// 是否远程请求数据
            //remote模式，修改发送请求的参数名称
            if (mode == 'remote') {
            	queryRemote(combo, keyword);
            } else {
            //local模式，在前端过滤数据
				queryLocal(combo, keyword);
            }
		}
		
		function queryRemote(combo, keyword) {
			var comgrid = combo.commonCombogrid("grid");
			var options = combo.commonCombogrid("options");
			var queryMinCharLength = options.queryMinCharLength;
        	var keywordName = options.queryParamName;// 获取参数请求名称
            var queryParams = comgrid.datagrid('options').queryParams; 
        	if (keyword && keyword.length >= queryMinCharLength) {
        		var queryParamStr = "{" + keywordName + " : \"" + keyword + "\"}";
	                var queryParamJson =  eval('(' + queryParamStr + ')');
					$.extend(queryParams, queryParamJson);
	                comgrid.datagrid('options').queryParams = queryParams;
	                comgrid.datagrid("reload");    //重新加载
	                combo.commonCombogrid("setValue", keyword);
        	}
		}
		
		function queryLocal(combo, keyword) {
			var comgrid = combo.commonCombogrid("grid");
			var options = combo.commonCombogrid("options");
			var filterFields = options.filterFields;// 过滤字段名称
			var rows = $.data(comgrid[0],"allRows");
			var keywords = options.multiple ? keyword.split(options.separator) : [keyword];
			var filterRows = [];
			$.each(rows, function(i, row){
				if (likeInCombogridList(row, filterFields, keywords)) {
					filterRows.push(row);
				}
			});
			$.data(comgrid[0], 'originalRows', null);//清空查询条件下所有rows
			comgrid.datagrid('loadData', filterRows);//重新设置查询条件下所有rows
			combo.commonCombogrid("setValue", keyword);
		}
		
		function filter(target, keyword, row) {
			var combo = $(target);
			var comgrid = combo.commonCombogrid("grid");
			var options = combo.commonCombogrid("options");
			var filterFields = options.filterFields;// 过滤字段名称
			var keywords = options.multiple ? keyword.split(options.separator) : [keyword];
			if (likeInCombogridList(row, filterFields, keywords)) {
				return true;
			}
			return false;
		}
		
		function limitValueInCombogridList(target) {
			var combo = $(target);
			var options = combo.commonCombogrid('options');
			var limitToList = options.limitToList;
			if (limitToList) {
				var existInList = false;
				var filterFields = options.filterFields;// 过滤字段名称
				var textField = options.textField;// 过滤字段名称
				var idField = options.idField;//id 字段
				var textbox = combo.commonCombogrid('textbox').parent().find('.textbox-text');
				var keyword = $(textbox[0]).val();
				var keywords = options.multiple ? keyword.split(options.separator) : [keyword];
				var rows = combo.commonCombogrid('grid').datagrid('getData').rows;
				var values = [];
				for (var i = 0; i < rows.length; i++) {
					if (matchFullInCombogridList(rows[i], filterFields, keywords)) {
						existInList = true;
						values.push(rows[i][idField]);
					}
				}
//				if (values.length == 0) {
//					var valuestr = "";
//					for (var i = 0; i < values.length ; i++) {
//						valuestr += values[i];
//					}
//					console.log("hide combogrid setvalue null,text = " + valuestr + "," + keyword + ",.....");
//				}
				combo.commonCombogrid('setValues', values);
			}
		}
		
		function likeInCombogridList(row, filterFields, keywords) {
			for (var i = 0; i < filterFields.length; i++) {
				for (var j = 0; j < keywords.length; j++) {
					if ((row[filterFields[i]] + "").toLowerCase().indexOf(keywords[j].toLowerCase()) >= 0) {
						return true;
					}
				}
			}
			return false;
		}
		
		function matchFullInCombogridList(row, filterFields, keywords) {
			var lowerKeywords = [];
			$.each(keywords, function(i, keyword) {
				lowerKeywords.push(keyword);
			});
			var matchField = $.grep(filterFields, function(filterField) {
				return $.inArray((row[filterField] + "").toLowerCase(), lowerKeywords) >= 0;
			});
			if (matchField && matchField.length > 0) {
				return true;
			}
			return false;
		}
	})(jQuery);

function loadCommonCombogrid(id, options) {
	if (!options.pageSize) {
		options.pageSize = 50;
	}
	if (!options.pageList) {
		options.pageList = [options.pageSize];
	}
	$("#" + id).commonCombogrid(options);
	$("#" + id).commonCombogrid('grid').datagrid('getPager').
	pagination({pageSize:options.pageSize,pageNumber:1,showPageList : false});
}

function loadEmpCombogrid(id, options) {
	loadCommonCombogrid(id, $.extend({panelWidth:400,
	    pagination: true,
	    idField:'empId',	
	    textField:'empName', 
	    filterFields : ['empCode', 'empName'],//搜索条件
	    mode : 'remote',//当输入文本时，从后台拉取数据
	    //limitToList : true,//限制在列表范围内
	    queryParamName : 'keyword',
	    columns:[[
        {field:'empId',title:'员工id',width:100, hidden:true},
	    {field:'empCode',title:'员工编号',width:100},
	    {field:'empName',title:'员工名称',width:100}
	    ]]} , options))
}



$.fn.extend({
	/**
	 * 选择器：普通的 grid
	 * @param options
	 */
	parseCombogrid: function (options) {
		if (typeClass.isString(options)) {
			this.combogrid(options);
			return;
		}
		this.combogrid($.extend({
			loadMsg: '数据加载中请稍后...',
			pagination: true,
			fitColumns: true,
			mode: 'remote',
			onHidePanel: function () {
				var grid = $(this).combogrid('grid'); // get
				if (isNotEmpty(grid) && grid.length > 0) {
					var row = grid.datagrid('getSelected'); // get
					if (isEmpty(row)) {
						$(this).combogrid('clear');
						// 当前表单数据只剩一条
						var rows = grid.datagrid('getRows');
						if (typeClass.isArray(rows) && rows.length > 0) {
							$(this).combogrid('setValue', rows[0].empCode);
						}
					} else {
						$(this).combogrid('setValue', row.empCode);
					}
				}
			},
			onShowPanel: function () {
				/* 解决datagrid q值、页码缓存问题, */
				var value = $(this).combogrid('getValue');
				if (isEmpty(value)) {
					$(this).combogrid("grid").datagrid("load", { 'q': '' });
					$(this).combogrid("grid").datagrid('gotoPage', 1);
				}
			}
		}, options || {}));
		return this;
	}
})



/**
 * 获取：点击行数的索引
 * @param {Document} target 目标 html 标签
 */
function getRowIndex(target) {
	var tr = $(target).closest('tr.datagrid-row');
	return parseInt(tr.attr('datagrid-row-index'));
}


/**
 * 获取：点击行数的索引
 * @param {Document} target 目标 html 标签
 */
function getRowIndexMain(target) {
	var childContainer = getChildContainer(target);
	// 获取 主表行号
	return parseInt(childContainer.prev().attr('datagrid-row-index'));
}


/**
 * 获取：目标表
 * @param {Document} target 目标 html 标签
 */
function getTargetTable(target) {
	return $(target).closest("div.datagrid-view").find("table.datagrid-f");
}

/**
 * 获取包含字表的容器
 * @param {element} target 子表 内 元素
 */
function getChildContainer(target) {
	var rowdetail = $(target).closest('div.datagrid-row-detail');
	// 获取
	return rowdetail.parent().parent();
}


/**
 * 查找字表：通过行索引
 * @param {Number} index 主表行索引
 */
function findChildTable(index) {
	return $(this).datagrid('getRowDetail', index).find('table.child');
}

/**
 * 查找目标表
 */
function findTargetTable() {
	return $(this).closest('div.datagrid-view').children('table.datagrid-f');;
}


/**
 * 列编辑
 * @param {Number} index 行
 * @param {String} field 字段名
 */
function onClickCell(index, field){
	deepColseEditTable.call(this,true);
	$(this).datagrid('options').editIndex = index;
	$(this).datagrid('selectRow', index).datagrid('editCell', {index:index,field:field});
}

/**
 *
 * @param {Number} index 行号
 * @param {Boolean} status 非必填， true 开始编辑，false 结束编辑
 */
function deepEditRow(index, status, deep){
	$(this).datagrid("myEditRow", {
		index: index,
		editStatus: status,
		callback: function (index, status) {
			if(deep===true) {
				findChildTable.call(this, index).datagrid("myEditTable", { editStatus: status });
			}
		}
	});
}
/**
 * 深度闭合表
 */
function deepColseEditTable(deep){
	$(this).datagrid("myEditTable", {
		callback: function (index, status) {
			if(deep===true) {
				findChildTable.call(this, index).datagrid("myEditTable", { editStatus: status });
			}
		}
	});
}


$.extend($.fn.datagrid.methods, {
	/**
	 * 编辑列
	 * @param {*} jq
	 * @param {*} param
	 */
	editCell: function(jq,param){
		return jq.each(function(){
			var opts = $(this).datagrid('options');
			var fields = $(this).datagrid('getColumnFields',true).concat($(this).datagrid('getColumnFields'));
			for(var i=0; i<fields.length; i++){
				var col = $(this).datagrid('getColumnOption', fields[i]);
				col.editor1 = col.editor;
				if (fields[i] != param.field){
					col.editor = null;
				}
			}
			$(this).datagrid('myBeginEdit', {index: param.index});
			for(var i=0; i<fields.length; i++){
				var col = $(this).datagrid('getColumnOption', fields[i]);
				col.editor = col.editor1;
			}
		});
	},
	/**
	 * 合并列
	 * @param {*} jq
	 * @param {*} param
	 */
	mergeColumns: function (jq, param) {
		return jq.each(function () {
			var options = $(this).datagrid('options');
			var rows = $(this).datagrid('getRows');
			var groupCount = {};
			for (var i = 0; i < rows.length; i++) {
				var item = rows[i];
				var value = item[options.groupName];
				if (isEmpty(groupCount[value])) {
					groupCount[value] = { count: 1, index: i };
				} else {
					groupCount[value].count++;
				}
			}
			var columns = options.mergeColumns;
			for (var key in groupCount) {
				var obj = groupCount[key];
				for (var j = 0; j < columns.length; j++) {
					$(this).datagrid('mergeCells', {
						index: obj.index, field: columns[j], rowspan: obj.count
					});
				}
			}
		});
	},
	/**
	 * 设置表格字段
	 * @param {*} jq
	 * @param {*} param {fields:"目标列：Array",status:"编辑状态：Boolean"}
	 */
	editStatueColumns: function (jq, param) {
		return jq.each(function () {
			var fields = param.fields;
			for (var index = 0; index < fields.length; index++) {
				var field = fields[index];
				var col = $(this).datagrid('getColumnOption', field);
				if (param.status === true) {
					col.editor = col.editorInit;
				} else {
					if(isEmpty(col.editorInit)){
						(col.editorInit = col.editor)
					}
					col.editor = null;
				}
			}
		});
	},
	/**
	 * 开始编辑
	 * @param {*} jq
	 * @param {Object} param
	 */
	myBeginEdit: function (jq, param) {
		return jq.each(function () {
			var row = getRowData.call(this, param.index);
			if (row.editStatus === true) {
				// 正在编辑，不能再次开始编辑
			} else {
				row.editStatus = true;
				$(this).datagrid('beginEdit', param.index);
			}
		});
	},
	/**
	 * 结束编辑
	 * @param {*} jq
	 * @param {Object} param
	 */
	myEndEdit: function (jq, param) {
		return jq.each(function () {
			var row = getRowData.call(this, param.index);
			if (row.editStatus === true) {
				row.editStatus = false;
				if ($(this).datagrid('validateRow',  param.index)){
					$(this).datagrid('endEdit',  param.index);
				}
			}
		});
	},
	/**
	 * 编辑表
	 * @param {Boolean} editStatus 状态：true 开启编辑，flase 关闭编辑
	 * @param {Function} callback 回调函数
	 */
	myEditTable: function (jq, param) {
		return jq.each(function () {
			var rows = $(this).datagrid('getRows');
			for (var index = 0; index < rows.length; index++) {
				$(this).datagrid('myEditRow',{
					index: index,
					editStatus: param.editStatus,
					callback: param.callback
				});
			}
			rows = undefined;
		});
	},
	/**
	 * 编辑行
	 * @param {Number} index 行索引
	 * @param {Boolean} editStatus 状态：true 开启编辑，flase 关闭编辑
	 * @param {Function} callback 回调函数
	 */
	myEditRow: function (jq, param) {
		return jq.each(function () {
			if(param.editStatus === true) {
				$(this).datagrid('myBeginEdit', {index: param.index});
			} else {
				$(this).datagrid('myEndEdit', {index: param.index});
			}
			param.callback
			&& (param.callback instanceof Function)
			&& param.callback.call(this, param.index, param.editStatus);
		});
	}
});

/**
 * 获取行数据
 * @param {Number} index
 */
function getRowData(index) {
	var rows = $(this).datagrid('getRows');
	return rows[index];
}
//回车阻止事件传递(影响页面回车查询)
$.fn.combogrid.defaults.inputEvents.keyup = function(){
	if(event.code==='Enter' || event.keyCode ===13){
		if(event.stopPropagation){
			event.stopPropagation();
		}else{
			event.returnValue == false;
		}
	}
}

//调整datagrid,序号列宽度 bug ##2801 zhangfenghuang 2016-01-05 begin
$.extend($.fn.datagrid.methods, {
	fixRownumber: function (jq) {
		return jq.each(function () {
			var panel = $(this).datagrid("getPanel");
			//获取最后一行的number容器,并拷贝一份
			var clone = $(".datagrid-cell-rownumber", panel).last().clone();
			//由于在某些浏览器里面,是不支持获取隐藏元素的宽度,所以取巧一下
			clone.css({
				"position": "absolute",
				left: -1000
			}).appendTo("body");
			var width = clone.width("auto").width();
			//默认宽度是25,所以只有大于25的时候才进行fix
			if (width > 25) {
				//多加5个像素,保持一点边距
				$(".datagrid-header-rownumber,.datagrid-cell-rownumber", panel).width(width + 5);
				//修改了宽度之后,需要对容器进行重新计算,所以调用resize
				$(this).datagrid("resize");
				//一些清理工作
				clone.remove();
				clone = null;
			} else {
				//还原成默认状态
				$(".datagrid-header-rownumber,.datagrid-cell-rownumber", panel).removeAttr("style");
			}
		});
	}
});