(function($){
    
	var combotreegridPlugin = $.fn.combotreegrid;
    $.fn.commonCombotreegrid = function(options, param){
        if (typeof options != 'string'){
            return this.each(function(){
            	var commonOpts = $.extend({},$.fn.commonCombotreegrid.defaults,$.fn.commonCombotreegrid.parseOptions(this), options);
            	if (!commonOpts.filterFields) {
	    			commonOpts.filterFields = [commonOpts.treeField, commonOpts.idField];
	    		} else if (typeof commonOpts.filterFields == "string") {
	    			commonOpts.filterFields = [commonOpts.filterFields, commonOpts.idField];
	    		} else {
	    			commonOpts.filterFields.push(commonOpts.idField);
	    		}
            	combotreegridPlugin.call($(this), commonOpts, param);
            });
        } else {
        	var func = $.fn.commonCombotreegrid.methods[options];
        	if(func){
        		return func(this, param);
        	} else {
        		return combotreegridPlugin.call(this, options, param);
        	}
        }
    };
	
    $.fn.commonCombotreegrid.methods = $.extend({}, combotreegridPlugin.methods,{
        getSelected: function(jq){
            var options = jq.commonCombotreegrid('options');
            var key = options.idField;
            var values = jq.commonCombotreegrid('getValues');
            var data = jq.commonCombotreegrid('getData');
            var items = [];
            for(var i=0; i<data.length; i++){
                var item = data[i];
                if($.inArray(item[key], values) >= 0){
                	items.push = item;
                }
            }
            return items;
        }
    });

    $.fn.commonCombotreegrid.defaults = $.extend({}, combotreegridPlugin.defaults, {
    	headerData : null,
    	headerText : null,
    	headerValue : null,
    	master : null , 
    	queryParamName : "keyword", //设置默认请求参数名称：keyword
//    	keyHandler : $.extend({}, combotreegridPlugin.defaults.keyHandler, {
//			//用户输入时，过滤数据
//			query : function(keyword, e) {
//				var target = e.data.target;
//				var combotreegrid = $(target);
//				var mode = combotreegrid.commonCombotreegrid("options").mode;// 是否远程请求数据
//				query(combotreegrid, keyword);
//				if (mode != 'remote') {
//					if (combotreegridPlugin.defaults.keyHandler && combotreegridPlugin.defaults.keyHandler.query) {
//						combotreegridPlugin.defaults.keyHandler.query.call(this, keyword, e);
//					}
//				}
//			}
//		}) ,
//    	filter : function(keyword, row){
//    		var opts = $(this).commonCombotreegrid("options");
//    		var filterFields = opts.filterFields;
//    		return filterInCombotreegridList(row, filterFields, keyword);
//    	},
    	onHidePanel : function() {
			limitValueInCombotreegridList(this);
			if (combotreegridPlugin.defaults.onHidePanel) {
				combotreegridPlugin.defaults.onHidePanel.call(this);
			}
    	},
    	inputEvents : $.extend({}, combotreegridPlugin.defaults.inputEvents, {
    		blur : function(e) {
    			var target = e.data.target;
    			limitValueInCombotreegridList(target);
    			if (combotreegridPlugin.defaults.inputEvents.blur) {
    				combotreegridPlugin.defaults.inputEvents.blur.call(this, e);
    			}
    		}
    	})
    });
    
    $.fn.commonCombotreegrid.parseOptions = function(options) {
    	return $.extend({}, combotreegridPlugin.parseOptions(options), $.parser.parseOptions(options,["filterFields", "queryParamName"]));
    };
    $.fn.commonCombotreegrid.parseData = combotreegridPlugin.parseData;
    
    function query(combotreegrid, keyword) {
		var mode = combotreegrid.commonCombotreegrid("options").mode;// 是否远程请求数据
        //remote模式，修改发送请求的参数名称
        if (mode == 'remote') {
        	queryRemote(combotreegrid, keyword);
        } else {
        //local模式，在前端过滤数据
			queryLocal(combotreegrid, keyword);
        }
	}
	
	function queryRemote(combotreegrid, keyword) {
		var dg = combotreegrid.commonCombotreegrid("grid");
		var options = combotreegrid.commonCombotreegrid("options");
		var queryMinCharLength = options.queryMinCharLength;
    	var keywordName = options.queryParamName;// 获取参数请求名称
        var queryParams = dg.treegrid('options').queryParams; 
    	if (keyword && keyword.length >= queryMinCharLength) {
    		var queryParamStr = "{" + keywordName + " : \"" + keyword + "\"}";
                var queryParamJson =  eval('(' + queryParamStr + ')');
				$.extend(queryParams, queryParamJson);
				dg.treegrid('options').queryParams = queryParams;
				dg.treegrid("reload");    //重新加载
				combotreegrid.commonCombotreegrid("setValue", keyword);
    	}
	}
	
	function queryLocal(combotreegrid, keyword) {
		var dg = combotreegrid.commonCombotreegrid("grid");
		var options = combotreegrid.commonCombotreegrid("options");
		var filterFields = options.filterFields;// 过滤字段名称
		var rows = $.data(dg[0], "originalRows");
		if (!rows) {
			rows = dg.treegrid('getData');
			 $.data(dg[0], "originalRows", rows);
		}
		var keywords = options.multiple ? keyword.split(options.separator) : [keyword];
		var filterRows = [];
		$.easyui.forEach(rows, true, function(row){
			if (likeInCombotreegridList(row, filterFields, keywords)) {
				filterRows.push(row);
			}
		});
		dg.treegrid('loadData', filterRows);//重新设置查询条件下所有rows
		combotreegrid.commonCombotreegrid("setValue", keyword);
	}
    
    function likeInCombotreegridList(row, filterFields, keywords) {
    	for (var i = 0; i < filterFields.length; i++) {
			for (var j = 0; j < keywords.length; j++) {
				if ((row[filterFields[i]] + "").toLowerCase().indexOf(keywords[j].toLowerCase()) >= 0) {
					return true;
				}
			}
		}
    	return false;
	}
    
    function matchFullInCombotreegridList(row, filterFields, keyword) {
		if (typeof filterFields == "string") {
			return (row[filterFields] + "").toLowerCase() == keyword.toLowerCase();
		} else {
			var matchField = $.grep(filterFields, function(filterField) {
				return (row[filterField] + "").toLowerCase() == keyword.toLowerCase();
			});
			if (matchField && matchField.length > 0) {
				return true;
			}
			return false;
		}
	}
    
    function limitValueInCombotreegridList(target) {
    	var combotreegrid = $(target);
		var options = combotreegrid.commonCombotreegrid('options');
		var limitToGrid = options.limitToGrid;
		if (limitToGrid) {
			if (options.onHidePanelTimer) {
				clearTimeout(options.onHidePanelTimer);
			}
			options.onHidePanelTimer = setTimeout(function() {
				var existInList = false;
				var filterFields = options.filterFields;// 过滤字段名称
				var idField = options.idField;
				var texts = combotreegrid.commonCombotreegrid('getValues');
				var rows = combotreegrid.commonCombotreegrid('getData');
				var values = [];
				$.each(rows, function(idx, row){
					$.each(texts, function(textIdx, text){
						if (matchFullInCombotreegridList(row, filterFields, text)) {
							values.push(row[idField]);
						}
					});
				});
//				if (values.length == 0) {
				var valuestr = "";
				for (var i = 0; i < values.length ; i++) {
					valuestr += values[i];
				}
					console.log("hide combotreegrid setvalue null,text = " + valuestr + "," + texts + ",.....");
//				}
				combotreegrid.commonCombotreegrid('setValues', values);
			}, 50);
		}
    }
	
    function fixRemoteFilterParam(target, queryParams) {
    	if (queryParams.q == undefined) {
    		return;
    	}
    	var combotreegrid = $(target);
		var options = combotreegrid.commonCombotreegrid('options');
		var queryParamName = options.queryParamName;
		var queryParamStr = "{" + queryParamName + " : \"" + queryParams.q + "\"}";
         var queryParamJson =  eval('(' + queryParamStr + ')');
		$.extend(queryParams, queryParamJson);
    }
    

})(jQuery);

function loadCombotreegrid(id, options) {
	
}