package ${package.Controller};

import cn.yto.base.page.BasePage;
import ${cfg.bizPackage}.${cfg.bizName};
import ${package.Entity}.${entity};
import org.springframework.web.bind.annotation.RequestMapping;
import javax.annotation.Resource;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.springframework.web.bind.annotation.RequestMethod;
<#if restControllerStyle>
import org.springframework.web.bind.annotation.RestController;
<#else>
import org.springframework.stereotype.Controller;
</#if>
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>
import java.util.List;
import java.util.Map;
/**
 * <p>
 * ${table.comment!} 前端控制器
 * </p>
 *
 * @author ${author}
 * @since ${date}
 */
<#if restControllerStyle>
@RestController
<#else>
@Controller
</#if>
@RequestMapping("<#if package.ModuleName??>/${package.ModuleName}</#if>/<#if controllerMappingHyphenStyle??>${controllerMappingHyphen}<#else>${table.entityPath}</#if>")
<#if kotlin>
class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
<#if superControllerClass??>
public class ${table.controllerName} extends ${superControllerClass} {
<#else>
public class ${table.controllerName} {
</#if>

    @Resource
    private ${cfg.bizName} ${cfg.bizImplName?uncap_first};

    /**
     * 查询list
     * @Description:
     */
    @RequestMapping("/selectList")
    public Map<String, Object> selectList(${entity} bean) {
        List<${entity}> list = ${cfg.bizImplName?uncap_first}.selectList(bean);
        return returnSuccess(list);
    }

    /**
     * 分页查询
     * @ pageNum : 页码,默认1
     * @ pageSize :  页面大小
     */
    @RequestMapping("/listPage")
    public Map<String, Object> listPage(${entity} bean, BasePage page) {
        Page<${entity}> result = PageHelper.startPage(page.getCurrentPage(), page.getPageSize())
                .doSelectPage(() -> ${cfg.bizImplName?uncap_first}.selectList(bean));
        return returnSuccess(result);
    }

    /**
     * 保存
     * @Description:
     */
    @RequestMapping(value = "/insert", method = {RequestMethod.POST})
    public Map<String, Object> insert(${entity} bean) {
        return returnSuccess(${cfg.bizImplName?uncap_first}.insert(bean));
    }

    /**
     * 更新
     * @Description:
     */
    @RequestMapping(value = "/updateById", method = {RequestMethod.POST})
    public Map<String, Object> updateById(${entity} bean) {
        return returnSuccess(${cfg.bizImplName?uncap_first}.updateById(bean));
    }

    /**
     * 删除
     * @Description:
     */
    @RequestMapping("/deleteById")
    public Map<String, Object> deleteById(String id) {
        int res = ${cfg.bizImplName?uncap_first}.deleteById(id);
        return returnSuccess(res);
    }

    /**
     * 查询详情
     * @Description:
     */
    @RequestMapping("/selectById")
    public Map<String, Object> selectById(${entity} bean) {
        bean = ${cfg.bizImplName?uncap_first}.selectById(bean);
        return returnSuccess(bean);
    }

}
</#if>
