/**
 *
 */
$.extend($.fn.validatebox.defaults.rules,{
	roleCode : {
   	    validator: function(value) {
   	    	var regex = /[\,\.\\\/\[\]{}<>()|"'!%;*?:+ =#$%^&*]+/g;
	        return !regex.test(value);
	     },
	    message: '不能包含空格和特殊字符< > [ ] { } ( ) : | " \\ / \' ! % ; * ? + = # $ % ^ & *'
    },
    chinaCode : {
   	    validator: function(value) {
   	    	var regex  = /^[^\x00-\xff\s]*$/;;
	        return !regex.test(value);
	     },
	    message: '不能包含中文'
    }
});
$(function() {
	/* 加载主界面grid*/
	var columns=[[
	    {field:"id",checkbox:"true"},
	  	{field:'des',title: '操作',align:'center',width: 100,formatter: formatAction},

	  	<#list table.fields as field>
	  	{field:'${field.propertyName}',title: '${field.comment}' ,align:'center',width: 150},
        </#list>
	  	{field:'createTime',title: '创建时间', align:'center',width: 130,formatter : formatTime},
	  	{field:'createEmp',title: '创建人', align:'center',width: 80},
	  	{field:'updateTime',title: '修改时间', align:'center',width: 130,formatter : formatTime},
	  	{field:'updateEmp',title: '修改人', align:'center',width: 80}
	    ]];

	  	var dataGridParams = {
	  		url : '',
	  		pageSize : 10,
	  		toolbar : '#tlb${cfg.jspName}',
	  		singleSelect : 'false',
	  		fitColumns : 'false',
	  		onBeforeLoad : function(param) {
	  			console.log('bf');
	  		},
	  		onLoadSuccess : function(data) {
	  			$(this).datagrid("fixRownumber");
	  		},
	  		onLoadError : function() {
	  			//在载入远程数据产生错误的时候触发。
	  			console.error('error')
	  		}
	  	}
	  	/*加载表单数据*/
	  	newloadGrid('tbl${cfg.jspName}', columns, dataGridParams);

		/* 数据字典加载 */

		//新增关闭
		$('#dlg${cfg.jspName}').dialog({
		    onClose:function(){
		    	setEditControl(true);
		    }
		});
})
/*请求地址*/
var url = '';
var bCode = '';
var eCode = '';
/*下拉选择后处理*/


/**
 * 查询
 */
function find${cfg.jspName}() {
	if ($("#formFind${cfg.jspName}").form('validate')) {
		var datagrid=$('#tbl${cfg.jspName}').datagrid('options');
		datagrid.url= rootPath + "/${cfg.jspName?cap_first}/listPage";
		$('#tbl${cfg.jspName}').datagrid('load', serializeFormObj("formFind${cfg.jspName}"));
	}
}
/**
 * 打开编辑窗口
 */
function openAdd${cfg.jspName}(){
	bCode = '';
	eCode = '';
	openDialog("dlg${cfg.jspName}", '新增');
	$('#form${cfg.jspName}').form('clear');
	setEditControl(false)
	url = rootPath + "/${cfg.jspName}/insert";
}
/**
 * 打开编辑窗口
 */
function openUpdate${cfg.jspName}(e){
	/*获取当前选择行*/
	var row = $('#tbl${cfg.jspName}').datagrid('getRows')[e];
	if(row){
		openDialog("dlg${cfg.jspName}", '修改');
		$('#form${cfg.jspName}').form('load', row);
		setEditControl(true);

		 $.ajax({
             url: rootPath + '/${cfg.jspName?cap_first}/findByBaseOrgCode.do',
             data: {baseOrgCode:row.beginStationCode},
             task: function(data,statusText,xhr){
            		$('#hidBeginType').val(data.data.orgType);
             },
             fail: function(data,statusText,xhr){

             }
           });
		 $.ajax({
			 url: rootPath + '/${cfg.jspName?cap_first}/findByBaseOrgCode.do',
			 data: {baseOrgCode:row.endStationCode},
			 task: function(data,statusText,xhr){
				 $('#hidEndType').val(data.data.orgType);
			 },
			 fail: function(data,statusText,xhr){

			 }
		 });

		$('#cmbgdBeginStationCode').combogrid('grid').datagrid('reload',{'q':row.beginStationCode});
		$('#cmbgdBeginStationCode').combogrid('setValue',row.beginStationCode);
		$('#cmbgdEndStationCode').combogrid('grid').datagrid('reload',{'q':row.endStationCode});
		$('#cmbgdEndStationCode').combogrid('setValue',row.endStationCode);

	}
	url = rootPath + "/${cfg.jspName?cap_first}/updateById";
}
/**
 * 删除窗口
 */
function delete${cfg.jspName}(e){
	/*获取当前选择行*/
	var row = $('#tbl${cfg.jspName}').datagrid('getRows')[e];
	if(row){
		confirmMsg('您确定要删除选中的数据吗？', function(row) {
			$.ajax({
				url: rootPath + '/${cfg.jspName}/deleteById',
				data :{'id': row.id},
				task : function(data, statusText, xhr){
					reloadDatagrid('tbl${cfg.jspName}');
				}
			});
		}, [row]);
	}
}
/**
 * 批量窗口
 */
function batchDel${cfg.jspName}(){
	/*获取勾选对象*/
	var rows = $('#tbl${cfg.jspName}').datagrid('getChecked');
	var ids = [];
	rows.map(function(e){ids.push(e.id)});
	if(ids.length < 1){showInfoMsg("请先选择要删除的数据！"); return}
	ids  = ids.join(',');
	confirmMsg('请确认是否删除数据',function() {
		$.ajax({
			url:rootPath + '/${cfg.jspName}/batchDelete.do',
			data :{ids : ids},
			task: function(data) {
				reloadDatagrid('tbl${cfg.jspName}');
			}
		});
	});
}
/**
 * 保存线路
 */
function save${cfg.jspName}(){
	$('#hidBeginStationName').val($('#cmbgdBeginStationCode').combogrid('getText'));
	$('#hidEndStationName').val($('#cmbgdEndStationCode').combogrid('getText'));

	var bStationCode = $('#cmbgdBeginStationCode').combogrid('getValue');
	var eStationCode = $('#cmbgdEndStationCode').combogrid('getValue');

	var endType  = $('#hidEndType').val();
	var beginType  = $('#hidBeginType').val();

	$("#form${cfg.jspName}").form('submit',{
		url: url,
		onSubmit: function(){
			if ($(this).form('validate')) {

				return true;
			}
			return false;
		},
		success: function(data){
			if (isEmptyObject(data)) {
				showErrorTip('服务器端异常');
				return;
			}
			var result = data;
			if (typeof data == 'string') {
				result = eval('('+ data +')');
			}
			if (result.success) {
				showTips(result.message,'success');
				closeDialog("dlg${cfg.jspName}");
				reloadDatagrid('tbl{cfg.jspName}');
			} else {
				showError(result);
			}
			uceLoading.close();

		}
	});
}

/*导入路线 open dialog*/
function import{cfg.jspName}(){
	openDialog("dlg{cfg.jspName}Import");
	$('#formImportExcel').form('clear');

}

/*上传导入文件*/
function uploadImportFile(){
	debugger;
    //校验文件是否excel
	if(checkData()){
  	   $('#formImportExcel').form('submit',{
             url: rootPath+'/{cfg.jspName}/import',
             onSubmit: function(){
     			if ($(this).form('validate')) {
     				uceLoading.show("请稍后...");
     				return true;
     			}
     			return false;
     		},
     		success: function(data){
    			if (isEmptyObject(data)) {
    				showErrorTip('服务器端异常');
    				return;
    			}
    			var result = data;
    			if (typeof data == 'string') {
    				result = eval('('+ data +')');
    			}
    			if (result.success) {
    				var message=result.message;
    				if(message == "success"){
    					showTips("导入成功",'success');
    				}else{
        				window.location.href = rootPath+'/${cfg.jspName}/exportErrorXls.do?importKey='+message;
    				}
    				closeDialog("dlg${cfg.jspName}Import");
    				reloadDatagrid('tbl${cfg.jspName}');
    			} else {
    				showImportError(result);
    			}
    			uceLoading.close();

    		}
         });
 	}
}
function showImportError(data){
	console.log(data);
	if (data && isEmptyObject(data.stackTrace)) {
		showImportErrorTip(data.message);
		return;
	}
	openWindow({
        id: 'winErrorDetail',
        title: '错误信息',
        width: 500,
        height:300,
        url: '../error/toErrorDetail.do',
        onLoad : function() {
        	$('#divErrorTitle').html(data.message);
        	$('#divErrorDetail').html(data.stackTrace);
        },
        onSave: function () {}
    })
}
function showImportErrorTip(msg, title, timeout) {
	if (isEmptyObject(msg)) {
		return;
	}
	//换行符变成<br>
	msg=msg.replace(new RegExp('\n', 'g'),'<br>')
	var	infoTitle = !title ? '消息' : title;
	var infoTimeout = !timeout ? 10000 : timeout;
	var msgtip = $.messager.show({
		msg: '<div class="messager-icon messager-error" ></div><div style="font-size:15px;font-weight:bold;margin-top:25;color:#464c5b;">'+infoTitle+'</div><div style="margin-top:0px;color:#777272;"><br>' + msg + '</div><div class="panel-tool" style="top:15px;right:5px;color: #657180;"><a class="panel-tool-close" ></a></div>',
		timeout: infoTimeout,
		showType: 'fade'
	});
	$('.messager-body').css('height','auto');
	$('.messager-body').css('max-height','500px');
	$('.messager-body').parents('.panel').css('right','5px');
	$('.messager-body').parents('.panel').css('bottom','100px');
	$('.messager-body').parents('.panel').css('border-radius','4px');
	$('.panel-tool').bind('click',function(){
		msgtip.window('close');
	})
}
/*excel表格 校验*/
function checkData(){
	var fileDir = $("#uploadFile").textbox('getValue');
	var suffix = fileDir.substr(fileDir.lastIndexOf("."));
	if("" == fileDir){
		showErrorMsg("选择需要导入的Excel文件！");
	    return false;
	}
	if(".xls" != suffix && ".xlsx" != suffix ){
	    showErrorMsg("选择Excel格式的文件导入！");
        return false;
    }
    return true;
}

/*下载 excel 模板*/
function download${cfg.jspName}Template(){
	$('#formFind${cfg.jspName}').form('submit',{
        url: rootPath + "/${cfg.jspName?cap_first}/downloadTemplate",
        onSubmit: function(){
            if($(this).form('validate')) {
            	return true;
            }
            return false;
        },
        success: function(data){
			if (isEmptyObject(data)) {
				showErrorTip('服务器端异常');
				return;
			}
		}
    });
}

/* 设置控件编辑控制 */
function setEditControl(flag){
	$('#cmbgdBeginStationCode').combogrid({readonly:flag,required:!flag});
	$('#cmbgdEndStationCode').combogrid({readonly:flag,required:!flag});
}
/*重置重新处理*/
function rest${cfg.jspName}(){
	$('#formFind${cfg.jspName}').form('reset');
	$('#findBeginStationCode').combogrid("grid").datagrid("reload", {'q': ''});
}
/*停用*/
function statusModify(e){
	/*获取当前选择行*/
	var row = $('#tbl${cfg.jspName}').datagrid('getRows')[e];
	if(row){

	}
}
/*操作栏按钮处理*/
function formatAction(value,rec,index){

}

/**
 * 关闭新增界面
 */
function close${cfg.jspName}(){
	setEditControl(true);
	$('#dlg${cfg.jspName}').window('close');
}

//点击导出
 function exportXls(){
	 var exportRows = $('#tbl${cfg.jspName}').datagrid('getRows');
     if(!exportRows || exportRows.length <= 0){
	     showInfoMsg("没有查询到数据，无法导出！");
	     return;
	 }


 }
